/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ChainData
extends NeedUpdateData {
    public List<Entity> chainedTo;
    private List<Integer> chainedToIds;
    private List<UUID> chainedToUUIDs;
    private boolean isInitialized;

    public void tickChain(LivingEntity entity) {
        if (!this.isInitialized) {
            this.initialize(entity.level());
        }
        if (this.chainedTo == null) {
            return;
        }
        for (Entity chain : this.chainedTo) {
            double distance = chain.distanceTo((Entity)entity);
            if (!(distance > 7.0)) continue;
            double x = (chain.getX() - entity.getX()) / distance;
            double y = (chain.getY() - entity.getY()) / distance;
            double z = (chain.getZ() - entity.getZ()) / distance;
            entity.setDeltaMovement(entity.getDeltaMovement().add(x * Math.abs(x) * 0.4, y * Math.abs(y) * 0.2, z * Math.abs(z) * 0.4));
        }
    }

    public List<Entity> getChainedTo() {
        return Objects.requireNonNullElse(this.chainedTo, Collections.emptyList());
    }

    public void clearChains() {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo = null;
        this.triggerUpdate();
    }

    public void attachChain(Entity chain) {
        if (this.chainedTo == null) {
            this.chainedTo = new ArrayList<Entity>();
        } else if (this.chainedTo.contains(chain)) {
            return;
        }
        this.chainedTo.add(chain);
        this.triggerUpdate();
    }

    public void removeChain(Entity chain) {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo.remove(chain);
        this.triggerUpdate();
        if (this.chainedTo.isEmpty()) {
            this.chainedTo = null;
        }
    }

    public boolean isChainedTo(Entity toCheck) {
        if (this.chainedTo == null || this.chainedTo.isEmpty()) {
            return false;
        }
        return this.chainedTo.contains(toCheck);
    }

    public void serialize(CompoundTag tag) {
        CompoundTag chainedData = new CompoundTag();
        ListTag uuids = new ListTag();
        if (this.chainedTo != null) {
            int[] ids = new int[this.chainedTo.size()];
            for (int i = 0; i < this.chainedTo.size(); ++i) {
                Entity entity = this.chainedTo.get(i);
                ids[i] = entity.getId();
                uuids.add((Object)NbtUtils.createUUID((UUID)entity.getUUID()));
            }
            chainedData.putIntArray("chainedToIds", ids);
            chainedData.put("chainedToUUIDs", (Tag)uuids);
        }
        tag.put("chainedData", (Tag)chainedData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag chainedData = tag.getCompound("chainedData");
        int[] loadedChainedToIds = chainedData.getIntArray("chainedToIds");
        ListTag uuids = chainedData.getList("chainedToUUIDs", 11);
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.chainedToIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.chainedToIds.add(loadedChainedToId);
            }
        } else {
            this.chainedToIds = null;
        }
        if (!uuids.isEmpty()) {
            this.chainedToUUIDs = new ArrayList<UUID>();
            Object object = uuids.iterator();
            while (object.hasNext()) {
                Tag uuid = (Tag)object.next();
                this.chainedToUUIDs.add(NbtUtils.loadUUID((Tag)uuid));
            }
        } else {
            this.chainedToUUIDs = null;
        }
    }

    private void initialize(Level level) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.chainedToUUIDs != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (UUID uuid : this.chainedToUUIDs) {
                Entity entity = serverLevel.getEntity(uuid);
                if (entity == null) continue;
                entities.add(entity);
            }
            this.triggerUpdate();
        } else if (this.chainedToIds != null) {
            for (int id : this.chainedToIds) {
                Entity entity;
                if (id == -1 || (entity = level.getEntity(id)) == null) continue;
                entities.add(entity);
            }
        }
        this.chainedTo = !entities.isEmpty() ? entities : null;
        this.chainedToIds = null;
        this.chainedToUUIDs = null;
        this.isInitialized = true;
    }
}

