/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record DragonColor(String name, ChatFormatting color, DragonType dragonType, Supplier<Item> eggItem, Supplier<Item> scaleItem) {
    private static final List<DragonColor> VALUES = new ArrayList<DragonColor>();
    private static final Map<String, DragonColor> ID_MAP = new HashMap<String, DragonColor>();
    private static final Map<DragonType, List<DragonColor>> BY_DRAGON_TYPE = new HashMap<DragonType, List<DragonColor>>();
    public static final DragonColor RED = new DragonColor("red", ChatFormatting.DARK_RED, DragonType.FIRE, (Supplier<Item>)IafItems.DRAGONEGG_RED, (Supplier<Item>)IafItems.DRAGONSCALES_RED);
    public static final DragonColor GREEN = new DragonColor("green", ChatFormatting.DARK_GREEN, DragonType.FIRE, (Supplier<Item>)IafItems.DRAGONEGG_GREEN, (Supplier<Item>)IafItems.DRAGONSCALES_GREEN);
    public static final DragonColor BRONZE = new DragonColor("bronze", ChatFormatting.GOLD, DragonType.FIRE, (Supplier<Item>)IafItems.DRAGONEGG_BRONZE, (Supplier<Item>)IafItems.DRAGONSCALES_BRONZE);
    public static final DragonColor GRAY = new DragonColor("gray", ChatFormatting.GRAY, DragonType.FIRE, (Supplier<Item>)IafItems.DRAGONEGG_GRAY, (Supplier<Item>)IafItems.DRAGONSCALES_GRAY);
    public static final DragonColor BLUE = new DragonColor("blue", ChatFormatting.AQUA, DragonType.ICE, (Supplier<Item>)IafItems.DRAGONEGG_BLUE, (Supplier<Item>)IafItems.DRAGONSCALES_BLUE);
    public static final DragonColor WHITE = new DragonColor("white", ChatFormatting.WHITE, DragonType.ICE, (Supplier<Item>)IafItems.DRAGONEGG_WHITE, (Supplier<Item>)IafItems.DRAGONSCALES_WHITE);
    public static final DragonColor SAPPHIRE = new DragonColor("sapphire", ChatFormatting.BLUE, DragonType.ICE, (Supplier<Item>)IafItems.DRAGONEGG_SAPPHIRE, (Supplier<Item>)IafItems.DRAGONSCALES_SAPPHIRE);
    public static final DragonColor SILVER = new DragonColor("silver", ChatFormatting.DARK_GRAY, DragonType.ICE, (Supplier<Item>)IafItems.DRAGONEGG_SILVER, (Supplier<Item>)IafItems.DRAGONSCALES_SILVER);
    public static final DragonColor ELECTRIC = new DragonColor("electric", ChatFormatting.DARK_BLUE, DragonType.LIGHTNING, (Supplier<Item>)IafItems.DRAGONEGG_ELECTRIC, (Supplier<Item>)IafItems.DRAGONSCALES_ELECTRIC);
    public static final DragonColor AMETHYST = new DragonColor("amethyst", ChatFormatting.LIGHT_PURPLE, DragonType.LIGHTNING, (Supplier<Item>)IafItems.DRAGONEGG_AMETHYST, (Supplier<Item>)IafItems.DRAGONSCALES_AMETHYST);
    public static final DragonColor COPPER = new DragonColor("copper", ChatFormatting.GOLD, DragonType.LIGHTNING, (Supplier<Item>)IafItems.DRAGONEGG_COPPER, (Supplier<Item>)IafItems.DRAGONSCALES_COPPER);
    public static final DragonColor BLACK = new DragonColor("black", ChatFormatting.DARK_GRAY, DragonType.LIGHTNING, (Supplier<Item>)IafItems.DRAGONEGG_BLACK, (Supplier<Item>)IafItems.DRAGONSCALES_BLACK);

    public DragonColor(String name, ChatFormatting color, DragonType dragonType, Supplier<Item> eggItem, Supplier<Item> scaleItem) {
        this.name = name;
        this.color = color;
        this.dragonType = dragonType;
        this.eggItem = eggItem;
        this.scaleItem = scaleItem;
        VALUES.add(this);
        ID_MAP.put(name, this);
        if (!BY_DRAGON_TYPE.containsKey(dragonType)) {
            BY_DRAGON_TYPE.put(dragonType, new ArrayList());
        }
        BY_DRAGON_TYPE.get(dragonType).add(this);
    }

    public static List<DragonColor> values() {
        return ImmutableList.copyOf(VALUES);
    }

    public static DragonColor byMetadata(int meta) {
        DragonColor i = DragonColor.values().get(meta);
        return i == null ? RED : i;
    }

    public static DragonColor getById(String id) {
        return ID_MAP.getOrDefault(id, RED);
    }

    public static List<DragonColor> getColorsByType(DragonType type) {
        return ImmutableList.copyOf((Collection)BY_DRAGON_TYPE.getOrDefault(type, new ArrayList()));
    }

    public Item getEggItem() {
        return this.eggItem.get();
    }

    public Item getScaleItem() {
        return this.scaleItem.get();
    }

    public ResourceLocation getEggTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/egg_%s.png", this.dragonType.getName(), this.name));
    }

    public ResourceLocation getTextureByEntity(EntityDragonBase dragon) {
        int stage = dragon.getDragonStage();
        if (dragon.isModelDead()) {
            if (dragon.getDeathStage() >= dragon.getAgeInDays() / 5 / 2) {
                return this.getSkeletonTexture(stage);
            }
            return this.getSleepTexture(stage);
        }
        if (dragon.isSleeping() || dragon.isBlinking()) {
            return this.getSleepTexture(stage);
        }
        return this.getBodyTexture(stage);
    }

    public ResourceLocation getBodyTexture(int stage) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/%s_%d.png", this.dragonType.getName(), this.name, stage));
    }

    public ResourceLocation getSleepTexture(int stage) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/%s_%d_sleeping.png", this.dragonType.getName(), this.name, stage));
    }

    public ResourceLocation getEyesTexture(int stage) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/%s_%d_eyes.png", this.dragonType.getName(), this.name, stage));
    }

    public ResourceLocation getSkeletonTexture(int stage) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/%s_skeleton_%d.png", this.dragonType.getName(), this.dragonType.getName(), stage));
    }

    public ResourceLocation getMaleOverlay() {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)String.format("textures/entity/%sdragon/male_%s.png", this.dragonType.getName(), this.name));
    }
}

