/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection.diff;

import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiff;
import org.cyclops.cyclopscore.ingredient.collection.diff.IngredientCollectionDiffHelpers;

public class IngredientCollectionDiffManager<T, M> {
    private final IngredientComponent<T, M> ingredientComponent;
    private IngredientCollectionPrototypeMap<T, M> instancesCache;

    public IngredientCollectionDiffManager(IngredientComponent<T, M> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
        this.instancesCache = null;
    }

    public IngredientCollectionDiff<T, M> onChange(Iterator<T> newInstances) {
        IngredientCollectionPrototypeMap<T, M> newInstancesCache = new IngredientCollectionPrototypeMap<T, M>(this.ingredientComponent, true);
        IngredientCollectionDiff<T, M> diff = IngredientCollectionDiffHelpers.getDiff(this.ingredientComponent, this.instancesCache, newInstancesCache, newInstances);
        this.instancesCache = newInstancesCache;
        return diff;
    }

    public IngredientCollectionPrototypeMap<T, M> getInstancesCache() {
        if (this.instancesCache == null) {
            this.instancesCache = new IngredientCollectionPrototypeMap<T, M>(this.ingredientComponent, true);
        }
        return this.instancesCache;
    }
}

