/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl;

import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.EmojiProps;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.Norm2AllModes;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.UBiDiProps;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.UCaseProps;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.UCharacterProperty;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public final class CharacterPropertiesImpl {
    private static final int NUM_INCLUSIONS = 43;
    private static final UnicodeSet[] inclusions = new UnicodeSet[43];

    public static synchronized void clear() {
        for (int i2 = 0; i2 < inclusions.length; ++i2) {
            CharacterPropertiesImpl.inclusions[i2] = null;
        }
    }

    private static UnicodeSet getInclusionsForSource(int src) {
        if (inclusions[src] == null) {
            UnicodeSet incl = new UnicodeSet();
            switch (src) {
                case 1: {
                    UCharacterProperty.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 2: {
                    UCharacterProperty.INSTANCE.upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 6: {
                    UCharacterProperty.INSTANCE.addPropertyStarts(incl);
                    UCharacterProperty.INSTANCE.upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 7: {
                    Norm2AllModes.getNFCInstance().impl.addPropertyStarts(incl);
                    UCaseProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 8: {
                    Norm2AllModes.getNFCInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 9: {
                    Norm2AllModes.getNFKCInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 10: {
                    Norm2AllModes.getNFKC_CFInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 11: {
                    Norm2AllModes.getNFCInstance().impl.addCanonIterPropertyStarts(incl);
                    break;
                }
                case 4: {
                    UCaseProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 5: {
                    UBiDiProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    UCharacterProperty.ulayout_addPropertyStarts(src, incl);
                    break;
                }
                case 15: {
                    EmojiProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 16: {
                    incl.add(12286);
                    incl.add(12288);
                    break;
                }
                case 17: {
                    UCharacterProperty.mathCompat_addPropertyStarts(incl);
                    break;
                }
                default: {
                    throw new IllegalStateException("getInclusions(unknown src " + src + ")");
                }
            }
            CharacterPropertiesImpl.inclusions[src] = incl.compact();
        }
        return inclusions[src];
    }

    private static UnicodeSet getIntPropInclusions(int prop) {
        assert (4096 <= prop && prop < 4121);
        int inclIndex = 18 + prop - 4096;
        if (inclusions[inclIndex] != null) {
            return inclusions[inclIndex];
        }
        int src = UCharacterProperty.INSTANCE.getSource(prop);
        UnicodeSet incl = CharacterPropertiesImpl.getInclusionsForSource(src);
        UnicodeSet intPropIncl = new UnicodeSet(0, 0);
        int numRanges = incl.getRangeCount();
        int prevValue = 0;
        for (int i2 = 0; i2 < numRanges; ++i2) {
            int rangeEnd = incl.getRangeEnd(i2);
            for (int c2 = incl.getRangeStart(i2); c2 <= rangeEnd; ++c2) {
                int value = UCharacter.getIntPropertyValue(c2, prop);
                if (value == prevValue) continue;
                intPropIncl.add(c2);
                prevValue = value;
            }
        }
        CharacterPropertiesImpl.inclusions[inclIndex] = intPropIncl.compact();
        return CharacterPropertiesImpl.inclusions[inclIndex];
    }

    public static synchronized UnicodeSet getInclusionsForProperty(int prop) {
        if (4096 <= prop && prop < 4121) {
            return CharacterPropertiesImpl.getIntPropInclusions(prop);
        }
        int src = UCharacterProperty.INSTANCE.getSource(prop);
        return CharacterPropertiesImpl.getInclusionsForSource(src);
    }
}

