/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.ByteSequence;

final class ByteArraySequence
implements ByteSequence {
    private final byte[] buffer;
    private final int start;
    private final int length;
    private int hash;

    ByteArraySequence(byte[] buffer, int start, int length) {
        assert (buffer.length >= start + length);
        assert (start >= 0);
        assert (length >= 0);
        this.buffer = buffer;
        this.start = start;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte byteAt(int index) {
        int resolvedIndex = this.start + index;
        if (resolvedIndex >= this.start + this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.buffer[resolvedIndex];
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buffer, this.start, this.start + this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ByteArraySequence) {
            ByteArraySequence other = (ByteArraySequence)obj;
            if (this.buffer == other.buffer) {
                return this.start == other.start && this.length == other.length;
            }
            if (this.length != other.length) {
                return false;
            }
            int thisHash = this.hash;
            int otherHash = other.hash;
            if (thisHash != 0 && otherHash != 0 && thisHash != otherHash) {
                return false;
            }
            int otherStart = other.start;
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.buffer[this.start + i2] == other.buffer[otherStart + i2]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)obj;
            if (this.length != other.length()) {
                return false;
            }
            for (int i3 = 0; i3 < this.length; ++i3) {
                if (this.buffer[this.start + i3] == other.byteAt(i3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0 && this.length > 0) {
            int end = this.start + this.length;
            h2 = 1;
            int i2 = this.start;
            while (i2 + 3 < end) {
                int h0 = this.buffer[i2 + 0] & 0xFF;
                int h1 = this.buffer[i2 + 1] & 0xFF00;
                int h22 = this.buffer[i2 + 2] & 0xFF0000;
                int h3 = this.buffer[i2 + 3] & 0xFF000000;
                h2 = 31 * h2 + (h0 | h1 | h22 | h3);
                i2 += 4;
            }
            while (i2 < end) {
                h2 = 31 * h2 + this.buffer[i2];
                ++i2;
            }
            this.hash = h2;
        }
        return h2;
    }

    @Override
    public ByteSequence subSequence(int startIndex, int endIndex) {
        int l2 = endIndex - startIndex;
        if (l2 < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(l2));
        }
        int realStartIndex = this.start + startIndex;
        if (realStartIndex < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(startIndex));
        }
        if (endIndex > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(realStartIndex + l2));
        }
        return new ByteArraySequence(this.buffer, realStartIndex, l2);
    }
}

