/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.language;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.cyclops.integratedscripting.api.language.ILanguageHandler;
import org.cyclops.integratedscripting.api.language.ILanguageHandlerRegistry;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;

public class LanguageHandlerRegistry
implements ILanguageHandlerRegistry {
    private static LanguageHandlerRegistry INSTANCE = new LanguageHandlerRegistry();
    private final Map<String, ILanguageHandler> extensionToHandlerMap = Maps.newHashMap();

    private LanguageHandlerRegistry() {
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
    }

    public static LanguageHandlerRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void register(ILanguageHandler translator) {
        for (String extension : translator.getExtensions()) {
            this.extensionToHandlerMap.put(extension, translator);
        }
    }

    @Override
    @Nullable
    public ILanguageHandler getProvider(Path filePath) {
        String extension = ScriptHelpers.getPathExtension(filePath);
        if (extension != null) {
            return this.extensionToHandlerMap.get(extension);
        }
        return null;
    }

    public void onServerStarted(ServerStartedEvent event) {
        for (ILanguageHandler languageHandler : this.extensionToHandlerMap.values()) {
            languageHandler.onServerStarted();
        }
    }
}

