/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSToIntegerAsIntNode.class)
public final class JSToIntegerAsIntNodeGen
extends JSToIntegerAsIntNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private StringData string_cache;

    private JSToIntegerAsIntNodeGen() {
    }

    @Override
    public int executeInt(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FFF) != 0) {
            JSToNumberNode toNumberNode_1;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return JSToIntegerAsIntNode.doInteger(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return JSToIntegerAsIntNode.doBoolean(arg0Value_);
            }
            if ((state_0 & 0xC) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if ((state_0 & 4) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return JSToIntegerAsIntNode.doLongInt32Range(arg0Value_);
                }
                if ((state_0 & 8) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return JSToIntegerAsIntNode.doLongOther(arg0Value_);
                }
            }
            if ((state_0 & 0x30) != 0 && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                if ((state_0 & 0x10) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                    return JSToIntegerAsIntNode.doSafeIntegerInt32Range(arg0Value_);
                }
                if ((state_0 & 0x20) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                    return JSToIntegerAsIntNode.doSafeIntegerOther(arg0Value_);
                }
            }
            if ((state_0 & 0x40) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C000) >>> 14, arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x1C000) >>> 14, arg0Value);
                return JSToIntegerAsIntNode.doDouble(arg0Value_);
            }
            if ((state_0 & 0x180) != 0) {
                if ((state_0 & 0x80) != 0 && JSGuards.isUndefined(arg0Value)) {
                    return JSToIntegerAsIntNode.doUndefined(arg0Value);
                }
                if ((state_0 & 0x100) != 0 && JSGuards.isJSNull(arg0Value)) {
                    return JSToIntegerAsIntNode.doNull(arg0Value);
                }
            }
            if ((state_0 & 0x200) != 0 && arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                return this.doSymbol(arg0Value_);
            }
            if ((state_0 & 0x400) != 0 && arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return this.doBigInt(arg0Value_);
            }
            if ((state_0 & 0x800) != 0 && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString)arg0Value;
                StringData s11_ = this.string_cache;
                if (s11_ != null) {
                    return this.doString(arg0Value_, s11_.nestedToIntegerNode_, s11_.stringToNumberNode_);
                }
            }
            if ((state_0 & 0x1000) != 0 && arg0Value instanceof JSObject) {
                JSObject arg0Value_ = (JSObject)arg0Value;
                JSToNumberNode toNumberNode_ = this.toNumberNode;
                if (toNumberNode_ != null) {
                    return this.doJSObject(arg0Value_, toNumberNode_);
                }
            }
            if ((state_0 & 0x2000) != 0 && (toNumberNode_1 = this.toNumberNode) != null && (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private int executeAndSpecialize(Object arg0Value) {
        int doubleCast0;
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return JSToIntegerAsIntNode.doInteger(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 2;
            return JSToIntegerAsIntNode.doBoolean(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                this.state_0_ = state_0 |= 4;
                return JSToIntegerAsIntNode.doLongInt32Range(arg0Value_);
            }
            if (!JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                this.state_0_ = state_0 |= 8;
                return JSToIntegerAsIntNode.doLongOther(arg0Value_);
            }
        }
        if (arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                this.state_0_ = state_0 |= 0x10;
                return JSToIntegerAsIntNode.doSafeIntegerInt32Range(arg0Value_);
            }
            if (!JSGuards.isLongRepresentableAsInt32(arg0Value_.longValue())) {
                this.state_0_ = state_0 |= 0x20;
                return JSToIntegerAsIntNode.doSafeIntegerOther(arg0Value_);
            }
        }
        if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            state_0 |= doubleCast0 << 14;
            this.state_0_ = state_0 |= 0x40;
            return JSToIntegerAsIntNode.doDouble(arg0Value_);
        }
        if (JSGuards.isUndefined(arg0Value)) {
            this.state_0_ = state_0 |= 0x80;
            return JSToIntegerAsIntNode.doUndefined(arg0Value);
        }
        if (JSGuards.isJSNull(arg0Value)) {
            this.state_0_ = state_0 |= 0x100;
            return JSToIntegerAsIntNode.doNull(arg0Value);
        }
        if (arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            this.state_0_ = state_0 |= 0x200;
            return this.doSymbol(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 0x400;
            return this.doBigInt(arg0Value_);
        }
        if (arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString)arg0Value;
            StringData s11_ = this.insert(new StringData());
            JSToIntegerAsIntNode nestedToIntegerNode__ = s11_.insert(JSToIntegerAsIntNode.create());
            Objects.requireNonNull(nestedToIntegerNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s11_.nestedToIntegerNode_ = nestedToIntegerNode__;
            JSStringToNumberNode stringToNumberNode__ = s11_.insert(JSStringToNumberNode.create());
            Objects.requireNonNull(stringToNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s11_.stringToNumberNode_ = stringToNumberNode__;
            VarHandle.storeStoreFence();
            this.string_cache = s11_;
            this.state_0_ = state_0 |= 0x800;
            return this.doString(arg0Value_, nestedToIntegerNode__, stringToNumberNode__);
        }
        if ((state_0 & 0x2000) == 0 && arg0Value instanceof JSObject) {
            JSToNumberNode toNumberNode_;
            JSObject arg0Value_ = (JSObject)arg0Value;
            JSToNumberNode toNumberNode__shared = this.toNumberNode;
            if (toNumberNode__shared != null) {
                toNumberNode_ = toNumberNode__shared;
            } else {
                toNumberNode_ = this.insert(JSToNumberNode.create());
                if (toNumberNode_ == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_;
            }
            this.state_0_ = state_0 |= 0x1000;
            return this.doJSObject(arg0Value_, toNumberNode_);
        }
        if (JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value)) {
            JSToNumberNode toNumberNode_1;
            JSToNumberNode toNumberNode_1_shared = this.toNumberNode;
            if (toNumberNode_1_shared != null) {
                toNumberNode_1 = toNumberNode_1_shared;
            } else {
                toNumberNode_1 = this.insert(JSToNumberNode.create());
                if (toNumberNode_1 == null) {
                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.toNumberNode == null) {
                VarHandle.storeStoreFence();
                this.toNumberNode = toNumberNode_1;
            }
            state_0 &= 0xFFFFEFFF;
            this.state_0_ = state_0 |= 0x2000;
            return this.doJSOrForeignObject(arg0Value, toNumberNode_1);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @NeverDefault
    public static JSToIntegerAsIntNode create() {
        return new JSToIntegerAsIntNodeGen();
    }

    @GeneratedBy(value=JSToIntegerAsIntNode.class)
    @DenyReplace
    private static final class StringData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        JSToIntegerAsIntNode nestedToIntegerNode_;
        @Node.Child
        JSStringToNumberNode stringToNumberNode_;

        StringData() {
        }
    }
}

