/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSCompareNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNodeGen;
import com.oracle.truffle.js.nodes.unary.IsIdenticalBooleanNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalIntegerNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalStringNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalUndefinedNode;
import com.oracle.truffle.js.nodes.unary.IsNullNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@NodeInfo(shortName="===")
@ImportStatic(value={JSRuntime.class, JSConfig.class})
public abstract class JSIdenticalNode
extends JSCompareNode {
    protected static final int STRICT_EQUALITY_COMPARISON = 0;
    protected static final int SAME_VALUE = 1;
    protected static final int SAME_VALUE_ZERO = 2;
    protected final int type;

    protected JSIdenticalNode(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right);
        this.type = type;
    }

    @NeverDefault
    public static JSIdenticalNode createStrictEqualityComparison() {
        return JSIdenticalNodeGen.create(null, null, 0);
    }

    @NeverDefault
    public static JSIdenticalNode createSameValue() {
        return JSIdenticalNodeGen.create(null, null, 1);
    }

    public static JSIdenticalNode createSameValue(JavaScriptNode left, JavaScriptNode right) {
        return JSIdenticalNodeGen.create(left, right, 1);
    }

    @NeverDefault
    public static JSIdenticalNode createSameValueZero() {
        return JSIdenticalNodeGen.create(null, null, 2);
    }

    public static JavaScriptNode createUnoptimized(JavaScriptNode left, JavaScriptNode right) {
        return JSIdenticalNodeGen.create(left, right, 0);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        if (left instanceof JSConstantNode.JSConstantNullNode) {
            return IsNullNode.create(right, true);
        }
        if (right instanceof JSConstantNode.JSConstantNullNode) {
            return IsNullNode.create(left, false);
        }
        if (left instanceof JSConstantNode.JSConstantStringNode) {
            return IsIdenticalStringNode.create((TruffleString)left.execute(null), right, true);
        }
        if (right instanceof JSConstantNode.JSConstantStringNode) {
            return IsIdenticalStringNode.create((TruffleString)right.execute(null), left, false);
        }
        if (left instanceof JSConstantNode.JSConstantIntegerNode) {
            return IsIdenticalIntegerNode.create((Integer)left.execute(null), right, true);
        }
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            return IsIdenticalIntegerNode.create((Integer)right.execute(null), left, false);
        }
        if (left instanceof JSConstantNode.JSConstantBooleanNode) {
            return IsIdenticalBooleanNode.create((Boolean)left.execute(null), right, true);
        }
        if (right instanceof JSConstantNode.JSConstantBooleanNode) {
            return IsIdenticalBooleanNode.create((Boolean)right.execute(null), left, false);
        }
        if (left instanceof JSConstantNode.JSConstantUndefinedNode) {
            return IsIdenticalUndefinedNode.create(right, true);
        }
        if (right instanceof JSConstantNode.JSConstantUndefinedNode) {
            return IsIdenticalUndefinedNode.create(left, false);
        }
        return JSIdenticalNodeGen.create(left, right, 0);
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    @Specialization
    protected static boolean doInt(int a2, int b2) {
        return a2 == b2;
    }

    @Specialization
    protected final boolean doDouble(double a2, double b2) {
        if (this.type == 0) {
            return a2 == b2;
        }
        if (this.type == 1) {
            if (Double.isNaN(a2)) {
                return Double.isNaN(b2);
            }
            if (a2 == 0.0 && b2 == 0.0) {
                return JSRuntime.isNegativeZero(a2) == JSRuntime.isNegativeZero(b2);
            }
            return a2 == b2;
        }
        assert (this.type == 2);
        if (Double.isNaN(a2)) {
            return Double.isNaN(b2);
        }
        return a2 == b2;
    }

    @Specialization
    protected static boolean doBoolean(boolean a2, boolean b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doBigInt(BigInt a2, BigInt b2) {
        return a2.compareTo(b2) == 0;
    }

    @Specialization
    protected static boolean doBigIntDouble(BigInt a2, double b2) {
        return false;
    }

    @Specialization
    protected static boolean doDoubleBigInt(double a2, BigInt b2) {
        return JSIdenticalNode.doBigIntDouble(b2, a2);
    }

    @Specialization(guards={"isUndefined(a)"})
    protected static boolean doUndefinedA(Object a2, Object b2) {
        return a2 == b2;
    }

    @Specialization(guards={"isUndefined(b)"})
    protected static boolean doUndefinedB(Object a2, Object b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doJSObjectA(JSObject a2, Object b2) {
        return a2 == b2;
    }

    @Specialization
    protected static boolean doJSObjectB(Object a2, JSObject b2) {
        return a2 == b2;
    }

    @Specialization(guards={"isJSNull(a)", "isJSNull(b)"})
    protected static boolean doNullNull(Object a2, Object b2) {
        return true;
    }

    @Specialization(guards={"isJSNull(a)", "isUndefined(b)"})
    protected static boolean doNullUndefined(Object a2, Object b2) {
        return false;
    }

    @Specialization(guards={"isUndefined(a)", "isJSNull(b)"})
    protected static boolean doUndefinedNull(Object a2, Object b2) {
        return false;
    }

    @Specialization(guards={"isJSNull(a)", "!isNullOrUndefined(b)"})
    protected static boolean doNullA(Object a2, Object b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary nullInterop) {
        assert (b2 != Undefined.instance);
        return nullInterop.isNull(b2);
    }

    @Specialization(guards={"!isNullOrUndefined(a)", "isJSNull(b)"})
    protected static boolean doNullB(Object a2, Object b2, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary nullInterop) {
        assert (a2 != Undefined.instance);
        return nullInterop.isNull(a2);
    }

    @Specialization(guards={"isReferenceEquals(a, b)"})
    protected static boolean doTruffleStringIdentity(TruffleString a2, TruffleString b2) {
        return true;
    }

    @Specialization(replaces={"doTruffleStringIdentity"})
    protected static boolean doTruffleString(TruffleString a2, TruffleString b2, @Cached TruffleString.EqualNode equalsNode) {
        return equalsNode.execute(a2, b2, TruffleString.Encoding.UTF_16);
    }

    @Specialization
    protected static boolean doSymbol(Symbol a2, Symbol b2) {
        return a2 == b2;
    }

    @Specialization(guards={"isBoolean(a) != isBoolean(b)"})
    protected static boolean doBooleanNotBoolean(Object a2, Object b2) {
        assert (a2 != null && b2 != null);
        return false;
    }

    @Specialization(guards={"isSymbol(a) != isSymbol(b)"})
    protected static boolean doSymbolNotSymbol(Object a2, Object b2) {
        assert (a2 != null && b2 != null);
        return false;
    }

    @Specialization(guards={"isString(a) != isString(b)"})
    protected static boolean doStringNotString(Object a2, Object b2) {
        assert (a2 != null && b2 != null);
        return false;
    }

    @Specialization
    protected static boolean doLong(long a2, long b2) {
        return a2 == b2;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isAForeign || isBForeign"}, limit="InteropLibraryLimit")
    protected final boolean doForeignObject(Object a2, Object b2, @Bind(value="isForeignObjectOrNumber(a)") boolean isAForeign, @Bind(value="isForeignObjectOrNumber(b)") boolean isBForeign, @CachedLibrary(value="a") InteropLibrary aInterop, @CachedLibrary(value="b") InteropLibrary bInterop) {
        if (aInterop.isNumber(a2) && bInterop.isNumber(b2)) {
            return this.doForeignNumber(a2, b2, aInterop, bInterop, isAForeign, isBForeign);
        }
        return aInterop.isIdentical(a2, b2, bInterop) || aInterop.isNull(a2) && bInterop.isNull(b2);
    }

    private boolean doForeignNumber(Object a2, Object b2, InteropLibrary aInterop, InteropLibrary bInterop, boolean isAForeign, boolean isBForeign) {
        block12: {
            try {
                if (isAForeign != isBForeign) {
                    if (a2 instanceof BigInt) {
                        assert (!(b2 instanceof BigInt)) : b2;
                        return false;
                    }
                    if (b2 instanceof BigInt) {
                        assert (!(a2 instanceof BigInt)) : a2;
                        return false;
                    }
                } else assert (isAForeign && isBForeign && !(a2 instanceof BigInt) && !(b2 instanceof BigInt));
                if (aInterop.fitsInDouble(a2) && bInterop.fitsInDouble(b2)) {
                    return this.doDouble(aInterop.asDouble(a2), bInterop.asDouble(b2));
                }
                if (aInterop.fitsInLong(a2) && bInterop.fitsInLong(b2)) {
                    return aInterop.asLong(a2) == bInterop.asLong(b2);
                }
                if (aInterop.fitsInBigInteger(a2) && bInterop.fitsInBigInteger(b2)) {
                    return BigInt.fromBigInteger(aInterop.asBigInteger(a2)).compareTo(BigInt.fromBigInteger(bInterop.asBigInteger(b2))) == 0;
                }
            }
            catch (UnsupportedMessageException e2) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)e2);
            }
        }
        return false;
    }

    @Fallback
    protected static boolean doFallback(Object a2, Object b2) {
        assert (!JSRuntime.identical(a2, b2)) : String.valueOf(a2) + " (" + String.valueOf(a2 == null ? "null" : a2.getClass()) + "), " + String.valueOf(b2) + " (" + String.valueOf(b2 == null ? "null" : b2.getClass()) + ")";
        return false;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSIdenticalNodeGen.create(JSIdenticalNode.cloneUninitialized(this.getLeft(), materializedTags), JSIdenticalNode.cloneUninitialized(this.getRight(), materializedTags), this.type);
    }
}

