/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.helper.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class NumberUtil {
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E", "Y", "Z", "R", "Q"};
    private static final Style NUMBER = Style.EMPTY.withColor(8941311);
    private static final Style UNIT = Style.EMPTY.withColor(0xEE82EE);
    private static final DecimalFormat DF = new DecimalFormat("#.##");

    public static String formatBigInt(BigInteger number) {
        int unitIndex;
        if (number.compareTo(BigInteger.ZERO) < 0) {
            return "-" + NumberUtil.formatBigInt(number.negate());
        }
        BigDecimal temp = new BigDecimal(number, 0);
        for (unitIndex = 0; temp.compareTo(BigDecimal.TEN.pow(3)) >= 0 && unitIndex <= UNITS.length; ++unitIndex) {
            temp = temp.divide(BigDecimal.TEN.pow(3), 3, RoundingMode.HALF_DOWN);
        }
        String formattedNumber = DF.format(temp.doubleValue());
        if (unitIndex >= UNITS.length) {
            return String.format("%.2e", number.doubleValue());
        }
        return formattedNumber + UNITS[unitIndex];
    }

    public static String formatNum(double number) {
        if (number < 1000.0) {
            return DF.format(number);
        }
        int unit = Math.min((int)(Math.log10(number) / 3.0), UNITS.length - 1);
        return DF.format(number / Math.pow(1000.0, unit)) + UNITS[unit];
    }

    public static Component numberText(BigInteger number) {
        String text = NumberUtil.formatBigInt(number);
        if (text.matches(".*[a-zA-Z]$")) {
            return Component.literal((String)text.substring(0, text.length() - 1)).withStyle(NUMBER).append((Component)Component.literal((String)text.substring(text.length() - 1)).withStyle(UNIT));
        }
        if (text.contains("e+")) {
            String[] split = text.split("e\\+");
            return Component.literal((String)split[0]).withStyle(NUMBER).append((Component)Component.literal((String)"e+").withStyle(UNIT)).append((Component)Component.literal((String)split[1]).withStyle(NUMBER));
        }
        return Component.literal((String)text).withStyle(NUMBER);
    }
}

