/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae;

import appeng.api.AECapabilities;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import com.mojang.logging.LogUtils;
import de.mari_023.ae2wtlib.api.terminal.ItemWT;
import lu.kolja.expandedae.ExpConfig;
import lu.kolja.expandedae.definition.ExpBlockEntities;
import lu.kolja.expandedae.definition.ExpBlocks;
import lu.kolja.expandedae.definition.ExpCodecs;
import lu.kolja.expandedae.definition.ExpCreativeTab;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.definition.ExpMenus;
import lu.kolja.expandedae.definition.ExpUpgrades;
import lu.kolja.expandedae.part.ExpPatternProviderPart;
import lu.kolja.expandedae.xmod.XMod;
import lu.kolja.expandedae.xmod.ae2wtlib.WTLibIntegration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="expandedae")
public class Expandedae {
    public static final String MODID = "expandedae";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Expandedae(IEventBus modEventBus, ModContainer container) {
        ExpItems.DR.register(modEventBus);
        ExpBlocks.DR.register(modEventBus);
        ExpBlockEntities.DR.register(modEventBus);
        ExpMenus.DR.register(modEventBus);
        ExpCreativeTab.DR.register(modEventBus);
        ExpCodecs.CONDITIONAL_CODECS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::initCapabilities);
        modEventBus.addListener(this::initPartCapabilities);
        if (ModList.get().isLoaded("ae2wtlib")) {
            modEventBus.addListener(WTLibIntegration::registerMenu);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExpConfig.SPEC);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new XMod();
        new ExpUpgrades(event);
    }

    private void initCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder type : ExpBlockEntities.DR.getEntries()) {
            event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)type.get(), (be, context) -> (IInWorldGridNodeHost)be);
        }
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, ExpBlockEntities.EXP_PATTERN_PROVIDER.get(), (be, context) -> be.getLogic().getReturnInv());
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new PoweredItemCapabilities(stack, (IAEItemPowerStorage)((ItemWT)ExpItems.WIRELESS_EXP_ENCODING_TERMINAL.get())), new ItemLike[]{ExpItems.WIRELESS_EXP_ENCODING_TERMINAL.get()});
    }

    private void initPartCapabilities(RegisterPartCapabilitiesEvent event) {
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.getLogic().getReturnInv(), ExpPatternProviderPart.class);
    }
}

