/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.autocrafting.advancedautocrafter;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import edivad.extrastorage.autocrafting.advancedautocrafter.AdvancedAutocrafterBlockEntity;
import edivad.extrastorage.autocrafting.advancedautocrafter.AutocrafterPropertyTypes;
import edivad.extrastorage.autocrafting.advancedautocrafter.CrafterTier;
import edivad.extrastorage.network.to_client.AdvancedAutocrafterLockedUpdatePacket;
import edivad.extrastorage.network.to_client.AdvancedAutocrafterNameUpdatePacket;
import edivad.extrastorage.network.to_server.AdvancedAutocrafterNameChangePacket;
import edivad.extrastorage.setup.ESContainer;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AdvancedAutocrafterContainerMenu
extends AbstractBaseContainerMenu {
    private static final int PATTERN_SLOT_X = 8;
    private static final int PATTERN_SLOT_Y = 20;
    private final Player player;
    private final CrafterTier tier;
    private final boolean partOfChain;
    private final boolean headOfChain;
    private boolean locked;
    private final RateLimiter nameRateLimiter = RateLimiter.create((double)0.5);
    @Nullable
    private AdvancedAutocrafterBlockEntity autocrafter;
    @Nullable
    private Listener listener;
    private Component name;

    public AdvancedAutocrafterContainerMenu(int windowId, Inventory inventory, AutocrafterData data, CrafterTier tier) {
        super((MenuType)ESContainer.CRAFTER.get((Object)tier).get(), windowId);
        this.player = inventory.player;
        this.tier = tier;
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.LOCK_MODE, (Object)LockMode.NEVER));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.PRIORITY, (Object)0));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, (Object)true));
        this.addSlots((FilteredContainer)new PatternInventory(tier.getSlots(), () -> ((Player)inventory.player).level()), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER));
        this.name = Component.empty();
        this.partOfChain = data.partOfChain();
        this.headOfChain = data.headOfChain();
        this.locked = data.locked();
    }

    public AdvancedAutocrafterContainerMenu(int windowId, Inventory inventory, AdvancedAutocrafterBlockEntity autocrafter, CrafterTier tier) {
        super((MenuType)ESContainer.CRAFTER.get((Object)tier).get(), windowId);
        this.autocrafter = autocrafter;
        this.player = inventory.player;
        this.name = autocrafter.getDisplayName();
        this.partOfChain = false;
        this.headOfChain = false;
        this.locked = autocrafter.isLocked();
        this.tier = tier;
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.LOCK_MODE, autocrafter::getLockMode, autocrafter::setLockMode));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.PRIORITY, autocrafter::getPriority, autocrafter::setPriority));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, autocrafter::isVisibleToTheAutocrafterManager, autocrafter::setVisibleToTheAutocrafterManager));
        this.addSlots(autocrafter.getPatternContainer(), autocrafter.getUpgradeContainer());
    }

    public boolean canChangeName() {
        return !this.partOfChain;
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void broadcastChanges() {
        boolean newLocked;
        super.broadcastChanges();
        if (this.autocrafter == null) {
            return;
        }
        if (this.nameRateLimiter.tryAcquire()) {
            this.detectNameChange();
        }
        if (this.locked != (newLocked = this.autocrafter.isLocked())) {
            this.locked = newLocked;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new AdvancedAutocrafterLockedUpdatePacket(this.locked), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean stillValid(Player player) {
        if (this.autocrafter == null) {
            return true;
        }
        return Container.stillValidBlockEntity((BlockEntity)this.autocrafter, (Player)player);
    }

    private void detectNameChange() {
        if (this.autocrafter == null) {
            return;
        }
        Component newName = this.autocrafter.getDisplayName();
        if (!newName.equals((Object)this.name)) {
            this.name = newName;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new AdvancedAutocrafterNameUpdatePacket(newName), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void addSlots(FilteredContainer patternContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < this.tier.getRowsOfSlots(); ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new PatternSlot((Container)patternContainer, i * 9 + j, 8 + 18 * j, 20 + 18 * i, this.player.level()));
            }
        }
        for (i = 0; i < upgradeContainer.getContainerSize(); ++i) {
            this.addSlot((Slot)new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
        }
        switch (this.tier) {
            case IRON: {
                this.addPlayerInventory(this.player.getInventory(), 8, 91);
                break;
            }
            case GOLD: {
                this.addPlayerInventory(this.player.getInventory(), 8, 127);
                break;
            }
            case DIAMOND: {
                this.addPlayerInventory(this.player.getInventory(), 8, 163);
                break;
            }
            case NETHERITE: {
                this.addPlayerInventory(this.player.getInventory(), 8, 199);
            }
        }
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)upgradeContainer);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)patternContainer);
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.slots) {
            PatternSlot patternSlot;
            if (!(slot instanceof PatternSlot) || (patternSlot = (PatternSlot)slot).getItem() != stack) continue;
            return true;
        }
        return false;
    }

    public void changeName(String newName) {
        if (this.partOfChain) {
            return;
        }
        if (this.autocrafter != null) {
            this.autocrafter.setCustomName(newName);
            this.detectNameChange();
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new AdvancedAutocrafterNameChangePacket(newName), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void nameChanged(Component newName) {
        if (this.listener != null) {
            this.listener.nameChanged(newName);
        }
    }

    public void lockedChanged(boolean newLocked) {
        this.locked = newLocked;
        if (this.listener != null) {
            this.listener.lockedChanged(newLocked);
        }
    }

    @Generated
    public CrafterTier getTier() {
        return this.tier;
    }

    @Generated
    public boolean isPartOfChain() {
        return this.partOfChain;
    }

    @Generated
    public boolean isHeadOfChain() {
        return this.headOfChain;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    public static interface Listener {
        public void nameChanged(Component var1);

        public void lockedChanged(boolean var1);
    }
}

