/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.recipe.architectscutter;

import com.ldtteam.domumornamentum.IDomumOrnamentumApi;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.ldtteam.domumornamentum.util.DataComponentPatchBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class ArchitectsCutterRecipeBuilder {
    private final RecipeCategory category;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private final Block result;
    private int count = 1;
    private final DataComponentPatchBuilder components = new DataComponentPatchBuilder();

    public <T extends Block> ArchitectsCutterRecipeBuilder(T result, RecipeCategory category) {
        this.result = result;
        this.category = category;
    }

    public <T extends Comparable<T>> ArchitectsCutterRecipeBuilder resultProperty(Property<T> property, T value) {
        this.components.update(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY, props -> props.with(property, value));
        return this;
    }

    public ArchitectsCutterRecipeBuilder textureData(MaterialTextureData textureData) {
        if (textureData.isEmpty()) {
            return this;
        }
        this.components.set(IDomumOrnamentumApi.getInstance().getMaterialTextureComponentType(), textureData);
        return this;
    }

    public ArchitectsCutterRecipeBuilder count(int count) {
        this.count = count;
        return this;
    }

    public ArchitectsCutterRecipeBuilder unlockedBy(String criterionId, Criterion<?> criterion) {
        this.criteria.put(criterionId, criterion);
        return this;
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        ArchitectsCutterRecipe recipe = new ArchitectsCutterRecipe(BuiltInRegistries.BLOCK.getKey((Object)this.result), this.count, this.components.build());
        if (this.criteria.isEmpty()) {
            output.accept(recipeId, (Recipe)recipe, null);
            return;
        }
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        output.accept(recipeId, (Recipe)recipe, advancement.build(recipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    public void saveSuffix(RecipeOutput output, String suffix) {
        this.save(output, BuiltInRegistries.BLOCK.getKey((Object)this.result).withSuffix("_" + suffix));
    }

    public void save(RecipeOutput output, String name) {
        this.save(output, BuiltInRegistries.BLOCK.getKey((Object)this.result).withPath(name));
    }

    public void save(RecipeOutput output) {
        this.save(output, BuiltInRegistries.BLOCK.getKey((Object)this.result));
    }
}

