/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.entity.block;

import com.ldtteam.domumornamentum.DomumOrnamentum;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.component.ModDataComponents;
import com.ldtteam.domumornamentum.entity.block.AbstractMateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.entity.block.ModBlockEntityTypes;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MateriallyTexturedBlockEntity
extends AbstractMateriallyTexturedBlockEntity {
    private MaterialTextureData textureData = MaterialTextureData.EMPTY;

    public MateriallyTexturedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.MATERIALLY_TEXTURED.get(), pos, state);
    }

    @Override
    public void updateTextureDataWith(MaterialTextureData materialTextureData) {
        this.textureData = materialTextureData;
        if (this.textureData.isEmpty()) {
            this.textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(this.getBlockState().getBlock());
        } else {
            Block block = this.getBlockState().getBlock();
            if (block instanceof IMateriallyTexturedBlock) {
                IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)block;
                this.textureData = this.textureData.retainComponentsFromBlock(materiallyTexturedBlock);
            }
        }
        this.requestModelDataUpdate();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        RegistryOps dynamicops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        compound.put("textureData", (Tag)MaterialTextureData.CODEC.encodeStart((DynamicOps)dynamicops, (Object)this.textureData).getOrThrow());
    }

    public void loadAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        RegistryOps dynamicops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (nbt.contains("textureData")) {
            MaterialTextureData.CODEC.parse((DynamicOps)dynamicops, (Object)nbt.get("textureData")).resultOrPartial(arg_0 -> ((Logger)DomumOrnamentum.LOGGER).error(arg_0)).ifPresent(this::updateTextureDataWith);
        }
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
        if (this.level != null && this.level.isClientSide) {
            this.level.setBlocksDirty(this.worldPosition, Blocks.AIR.defaultBlockState(), this.getBlockState());
        }
    }

    public void onLoad() {
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)this.textureData).build();
    }

    @Override
    @NotNull
    public MaterialTextureData getTextureData() {
        return this.textureData;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.updateTextureDataWith((MaterialTextureData)componentInput.getOrDefault(ModDataComponents.TEXTURE_DATA, (Object)MaterialTextureData.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentBuilder) {
        super.collectImplicitComponents(componentBuilder);
        componentBuilder.set(ModDataComponents.TEXTURE_DATA, (Object)this.textureData);
    }

    public void removeComponentsFromTag(CompoundTag itemStackTag) {
        itemStackTag.remove("textureData");
    }
}

