/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.block;

import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCMenuBlockEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class BCMenu<T extends BCMenuBlockEntity>
extends AbstractContainerMenu {
    protected final T blockEntity;

    public BCMenu(MenuType<?> type, int id, Inventory inventory, T blockEntity) {
        super(type, id);
        this.blockEntity = blockEntity;
        this.addSlots(inventory);
    }

    public BCMenu(MenuType<?> type, int id, Inventory inventory, FriendlyByteBuf data) {
        this(type, id, inventory, (BCMenuBlockEntity)BCUtil.nonNull(inventory.player.level().getBlockEntity(data.readBlockPos())));
    }

    protected abstract void addSlots(Inventory var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int slotCount = ((BCMenuBlockEntity)((Object)this.blockEntity)).items.getSlots();
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (index < slotCount) {
            if (!this.moveItemStackTo(slot.getItem(), slotCount, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 9) {
            if (!this.moveItemStackTo(stack, 0, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount + 9, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 36) {
            if (!this.moveItemStackTo(stack, 0, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount, slotCount + 9, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }

    public boolean stillValid(Player player) {
        return ((BCBlockEntity)((Object)this.blockEntity)).stillValid(player);
    }

    public Component getDisplayName() {
        return ((BCMenuBlockEntity)((Object)this.blockEntity)).getDisplayName();
    }

    protected void addInventorySlots(Inventory inventory, int x, int y) {
        int i;
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, x + i * 18, y + 58));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, i * 9 + j + 9, x + j * 18, y + i * 18));
            }
        }
    }

    public static class BCSlot
    extends Slot {
        public BCSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return this.container.canPlaceItem(this.index, stack);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

