/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record StockroomCatalogItemEntry(ItemStack item, int count, List<BlockPos> containers) {
    public static final Codec<StockroomCatalogItemEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(StockroomCatalogItemEntry::item), (App)Codec.INT.fieldOf("count").forGetter(StockroomCatalogItemEntry::count), (App)BlockPos.CODEC.listOf().fieldOf("containers").forGetter(StockroomCatalogItemEntry::containers)).apply((Applicative)inst, StockroomCatalogItemEntry::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StockroomCatalogItemEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, StockroomCatalogItemEntry::item, (StreamCodec)ByteBufCodecs.INT, StockroomCatalogItemEntry::count, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), StockroomCatalogItemEntry::containers, StockroomCatalogItemEntry::new);

    public StockroomCatalogItemEntry(ItemStack item, List<BlockPos> containers) {
        this(item.copy(), item.getCount(), containers);
        this.item.setCount(1);
    }

    public StockroomCatalogItemEntry(ItemStack item) {
        this(item, List.of());
    }

    public StockroomCatalogItemEntry add(int count) {
        return new StockroomCatalogItemEntry(this.item, this.count + count, new ArrayList<BlockPos>(this.containers));
    }

    public StockroomCatalogItemEntry add(BlockPos container) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.containers);
        list.add(container);
        return new StockroomCatalogItemEntry(this.item, this.count, list);
    }
}

