/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.plumbline;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class PlumbLineItem
extends Item {
    public PlumbLineItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction face = context.getClickedFace();
        if (face == Direction.UP || context.getPlayer() == null) {
            return super.useOn(context);
        }
        BlockPos pos = context.getClickedPos().offset(face.getNormal());
        BlockState state = context.getLevel().getBlockState(pos);
        int count = 0;
        while (state.isAir() || state.getCollisionShape((BlockGetter)context.getLevel(), pos).isEmpty()) {
            ++count;
            pos = pos.below();
            state = context.getLevel().getBlockState(pos);
        }
        if (count <= 2) {
            return super.useOn(context);
        }
        context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.plumb_line.distance", (Object[])new Object[]{count}), true);
        return InteractionResult.SUCCESS;
    }
}

