/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.lockandkey;

import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.lockandkey.LockAndKeyBehavior;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LockAndKeyItem
extends Item {
    public LockAndKeyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.isSecondaryUseActive()) {
            return super.useOn(context);
        }
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        Player player = context.getPlayer();
        if (blockEntity == null || player == null) {
            return super.useOn(context);
        }
        ItemStack stack = context.getItemInHand();
        LockAndKeyBehavior<BlockEntity> behavior = BibliocraftApi.getLockAndKeyBehaviors().get(blockEntity);
        if (behavior == null) {
            return super.useOn(context);
        }
        Component name = behavior.getDisplayName(blockEntity);
        if (this.hasNoCustomName(player, stack, name)) {
            return InteractionResult.FAIL;
        }
        LockCode lock = behavior.getLockKey(blockEntity);
        if (lock == LockCode.NO_LOCK) {
            behavior.setLockKey(blockEntity, this.newLockCode(stack));
            blockEntity.setChanged();
            player.displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.lock_and_key.locked", (Object[])new Object[]{name}), true);
            return InteractionResult.SUCCESS;
        }
        if (lock.unlocksWith(stack)) {
            behavior.setLockKey(blockEntity, LockCode.NO_LOCK);
            blockEntity.setChanged();
            player.displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.lock_and_key.unlocked", (Object[])new Object[]{name}), true);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private LockCode newLockCode(ItemStack stack) {
        return new LockCode(((Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.empty())).getString());
    }

    private boolean hasNoCustomName(Player player, ItemStack stack, Component displayName) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return false;
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.bibliocraft.lock_and_key.no_custom_name", (Object[])new Object[]{displayName}), true);
        player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }
}

