/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ClockTrigger(int hour, int minute, boolean redstone, boolean sound) implements Comparable<ClockTrigger>
{
    public static final Codec<ClockTrigger> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("hour").forGetter(ClockTrigger::hour), (App)Codec.INT.fieldOf("minute").forGetter(ClockTrigger::minute), (App)Codec.BOOL.fieldOf("redstone").forGetter(ClockTrigger::redstone), (App)Codec.BOOL.fieldOf("sound").forGetter(ClockTrigger::sound)).apply((Applicative)inst, ClockTrigger::new));
    public static final StreamCodec<ByteBuf, ClockTrigger> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClockTrigger::hour, (StreamCodec)ByteBufCodecs.INT, ClockTrigger::minute, (StreamCodec)ByteBufCodecs.BOOL, ClockTrigger::redstone, (StreamCodec)ByteBufCodecs.BOOL, ClockTrigger::sound, ClockTrigger::new);

    public int getInGameTime() {
        return ((int)((double)(this.hour * 1000) + (double)(this.minute * 50) / 3.0) + 18000) % 24000;
    }

    @Override
    public int compareTo(ClockTrigger that) {
        int hour = Integer.compare(this.hour, that.hour);
        return hour != 0 ? hour : Integer.compare(this.minute, that.minute);
    }
}

