/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.screen.ClockScreen;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClockTriggerEditScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/clock_edit.png");
    private static final int WIDTH = 144;
    private static final int HEIGHT = 72;
    private final ClockScreen parent;
    @Nullable
    private final ClockTrigger old;
    private final int timeWidth;
    private final int separatorWidth;
    private final int redstoneWidth;
    private final int soundWidth;
    private int leftPos;
    private int topPos;
    private int contentLeftPos;
    private int contentTopPos;
    private EditBox hours;
    private EditBox minutes;
    private Checkbox redstone;
    private Checkbox sound;

    public ClockTriggerEditScreen(ClockScreen parent, @Nullable ClockTrigger old) {
        super(Translations.CLOCK_TITLE);
        this.parent = parent;
        this.old = old;
        Font font = ClientUtil.getFont();
        this.timeWidth = font.width((FormattedText)Translations.CLOCK_TIME);
        this.separatorWidth = font.width((FormattedText)Translations.CLOCK_TIME_SEPARATOR);
        this.redstoneWidth = font.width((FormattedText)Translations.CLOCK_EMIT_REDSTONE);
        this.soundWidth = font.width((FormattedText)Translations.CLOCK_EMIT_SOUND);
    }

    protected void init() {
        this.leftPos = (this.width - 144) / 2;
        this.topPos = (this.height - 72) / 2;
        this.contentLeftPos = (this.width - Math.min(132, BCUtil.max(this.timeWidth + this.separatorWidth + 90, this.redstoneWidth + 19, this.soundWidth + 19))) / 2;
        this.contentTopPos = this.topPos + 6;
        Font font = ClientUtil.getFont();
        this.hours = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(font, this.contentLeftPos + this.timeWidth + 2, this.contentTopPos, 40, 20, Translations.CLOCK_HOURS));
        this.hours.setHint(Translations.CLOCK_HOURS_HINT);
        this.hours.setFilter(s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= 0 && i < 24;
            }
            catch (NumberFormatException e) {
                return s.isEmpty();
            }
        });
        this.minutes = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(font, this.contentLeftPos + this.timeWidth + this.separatorWidth + 44, this.contentTopPos, 40, 20, Translations.CLOCK_MINUTES));
        this.minutes.setHint(Translations.CLOCK_MINUTES_HINT);
        this.minutes.setFilter(s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= 0 && i < 60;
            }
            catch (NumberFormatException e) {
                return s.isEmpty();
            }
        });
        this.redstone = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.empty(), (Font)font).pos(this.contentLeftPos, this.contentTopPos + 22).build());
        this.sound = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.empty(), (Font)font).pos(this.contentLeftPos, this.contentTopPos + 41).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> {
            try {
                if (this.old != null) {
                    this.parent.removeTrigger(this.old);
                }
                this.parent.addTrigger(new ClockTrigger(Integer.parseInt(this.hours.getValue()), Integer.parseInt(this.minutes.getValue()), this.redstone.selected(), this.sound.selected()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.onClose();
        }).bounds(this.leftPos, this.topPos + 72 + 4, 144, 20).build());
        if (this.old != null) {
            this.hours.setValue(String.valueOf(this.old.hour()));
            this.minutes.setValue(String.valueOf(this.old.minute()));
            if (this.old.redstone()) {
                this.redstone.onPress();
            }
            if (this.old.sound()) {
                this.sound.onPress();
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(ClientUtil.getFont(), Translations.CLOCK_TIME, this.contentLeftPos, this.contentTopPos + 6, 0x404040, false);
        graphics.drawString(ClientUtil.getFont(), Translations.CLOCK_TIME_SEPARATOR, this.contentLeftPos + this.timeWidth + 43, this.contentTopPos + 6, 0x404040, false);
        graphics.drawString(ClientUtil.getFont(), Translations.CLOCK_EMIT_REDSTONE, this.contentLeftPos + 19, this.contentTopPos + 27, 0x404040, false);
        graphics.drawString(ClientUtil.getFont(), Translations.CLOCK_EMIT_SOUND, this.contentLeftPos + 19, this.contentTopPos + 46, 0x404040, false);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 144, 72);
    }
}

