/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.items.AbstractComputerItem;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class TurtleItem
extends AbstractComputerItem {
    public static final CauldronInteraction CAULDRON_INTERACTION = (blockState, level, pos, player, hand, stack) -> {
        if (!stack.has(DataComponents.DYED_COLOR)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            stack.remove(DataComponents.DYED_COLOR);
            LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    };

    public TurtleItem(TurtleBlock block, Item.Properties settings) {
        super(block, settings);
    }

    public Component getName(ItemStack stack) {
        String baseString = this.getDescriptionId(stack);
        ITurtleUpgrade left = TurtleItem.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = TurtleItem.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return Component.translatable((String)(baseString + ".upgraded_twice"), (Object[])new Object[]{right.getAdjective(), left.getAdjective()});
        }
        if (left != null) {
            return Component.translatable((String)(baseString + ".upgraded"), (Object[])new Object[]{left.getAdjective()});
        }
        if (right != null) {
            return Component.translatable((String)(baseString + ".upgraded"), (Object[])new Object[]{right.getAdjective()});
        }
        return Component.translatable((String)baseString);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        String mod2;
        UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
        if (left != null && !(mod2 = TurtleUpgrades.instance().getOwner(left.holder())).equals("computercraft")) {
            return mod2;
        }
        UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
        if (right != null && !(mod = TurtleUpgrades.instance().getOwner(right.holder())).equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    @Nullable
    public static ITurtleUpgrade getUpgrade(ItemStack stack, TurtleSide side) {
        UpgradeData<ITurtleUpgrade> upgrade = TurtleItem.getUpgradeWithData(stack, side);
        return upgrade == null ? null : upgrade.upgrade();
    }

    @Nullable
    public static UpgradeData<ITurtleUpgrade> getUpgradeWithData(ItemStack stack, TurtleSide side) {
        return (UpgradeData)stack.get(side == TurtleSide.LEFT ? (DataComponentType)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get() : (DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get());
    }

    @Nullable
    public static TurtleOverlay getOverlay(ItemStack stack) {
        Holder overlay = (Holder)stack.get((DataComponentType)ModRegistry.DataComponents.OVERLAY.get());
        return overlay == null ? null : (TurtleOverlay)overlay.value();
    }

    public static int getFuelLevel(ItemStack stack) {
        Integer fuel = (Integer)stack.get((DataComponentType)ModRegistry.DataComponents.FUEL.get());
        return fuel == null ? 0 : fuel;
    }
}

