/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TurtleMoveCommand
implements TurtleCommand {
    private final MoveDirection direction;
    private static final AABB EMPTY_BOX = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        Direction direction = this.direction.toWorldDir(turtle);
        ServerLevel oldWorld = (ServerLevel)turtle.getLevel();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.relative(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(turtlePlayer, oldWorld, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        BlockState state = oldWorld.getBlockState(newPosition);
        if (!(oldWorld.isEmptyBlock(newPosition) || WorldUtil.isLiquidBlock((Level)oldWorld, newPosition) || state.canBeReplaced())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        VoxelShape collision = state.getCollisionShape((BlockGetter)oldWorld, oldPosition).move((double)newPosition.getX(), (double)newPosition.getY(), (double)newPosition.getZ());
        if (!oldWorld.isUnobstructed(null, collision)) {
            if (!Config.turtlesCanPush || this.direction == MoveDirection.UP || this.direction == MoveDirection.DOWN) {
                return TurtleCommandResult.failure("Movement obstructed");
            }
            List list = oldWorld.getEntitiesOfClass(Entity.class, TurtleMoveCommand.getBox(collision), x -> x != null && x.isAlive() && x.blocksBuilding);
            for (Entity entity : list) {
                AABB pushedBB = entity.getBoundingBox().move((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ());
                if (oldWorld.isUnobstructed(null, Shapes.create((AABB)pushedBB))) continue;
                return TurtleCommandResult.failure("Movement obstructed");
            }
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo((Level)oldWorld, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            case FORWARD: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }

    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, ServerLevel world, BlockPos position) {
        if (world.isOutsideBuildHeight(position)) {
            return TurtleCommandResult.failure(position.getY() < 0 ? "Too low to move" : "Too high to move");
        }
        if (!world.isInWorldBounds(position)) {
            return TurtleCommandResult.failure("Cannot leave the world");
        }
        if (turtlePlayer.isBlockProtected(world, position)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.isLoaded(position)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        if (!world.getWorldBorder().isWithinBounds(position)) {
            return TurtleCommandResult.failure("Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }

    private static AABB getBox(VoxelShape shape) {
        return shape.isEmpty() ? EMPTY_BOX : shape.bounds();
    }
}

