/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class TurtleInspectCommand
implements TurtleCommand {
    private final InteractDirection direction;

    public TurtleInspectCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        BlockPos oldPosition;
        BlockPos newPosition;
        Direction direction = this.direction.toWorldDir(turtle);
        Level world = turtle.getLevel();
        BlockReference block = new BlockReference(world, newPosition = (oldPosition = turtle.getPosition()).relative(direction));
        if (block.state().isAir()) {
            return TurtleCommandResult.failure("No block to inspect");
        }
        Map<String, Object> table = VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails(block);
        return TurtleCommandResult.success(new Object[]{table});
    }
}

