/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.turtle.TurtleUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;

public class TurtleEquipCommand
implements TurtleCommand {
    private final TurtleSide side;

    public TurtleEquipCommand(TurtleSide side) {
        this.side = side;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        UpgradeData<ITurtleUpgrade> newUpgrade;
        UpgradeData<ITurtleUpgrade> oldUpgrade = turtle.getUpgradeWithData(this.side);
        ItemStack selectedStack = turtle.getInventory().getItem(turtle.getSelectedSlot());
        if (!selectedStack.isEmpty()) {
            newUpgrade = TurtleUpgrades.instance().get((HolderLookup.Provider)turtle.getLevel().registryAccess(), selectedStack);
            if (newUpgrade == null) {
                return TurtleCommandResult.failure("Not a valid upgrade");
            }
        } else {
            newUpgrade = null;
        }
        if (newUpgrade != null) {
            turtle.getInventory().removeItem(turtle.getSelectedSlot(), 1);
        }
        if (oldUpgrade != null) {
            TurtleUtil.storeItemOrDrop(turtle, oldUpgrade.getUpgradeItem());
        }
        turtle.setUpgrade(this.side, newUpgrade);
        if (newUpgrade != null || oldUpgrade != null) {
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

