/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WiredModemFullBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty MODEM_ON = BooleanProperty.create((String)"modem");
    public static final BooleanProperty PERIPHERAL_ON = BooleanProperty.create((String)"peripheral");

    public WiredModemFullBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MODEM_ON, (Comparable)Boolean.valueOf(false))).setValue((Property)PERIPHERAL_ON, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODEM_ON, PERIPHERAL_ON});
    }

    protected final InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult interactionResult;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            interactionResult = modem.use(player);
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)PERIPHERAL_ON)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            modem.queueRefreshPeripheral(direction);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected final void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)PERIPHERAL_ON)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            modem.neighborChanged(neighbourPos);
        }
    }

    public final void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbour) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)PERIPHERAL_ON)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            modem.neighborChanged(neighbour);
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity modem = (WiredModemFullBlockEntity)blockEntity;
            modem.blockTick();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModRegistry.BlockEntities.WIRED_MODEM_FULL.get()).create(pos, state);
    }
}

