/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.diskdrive.MediaStack;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public final class DiskDriveBlockEntity
extends AbstractContainerBlockEntity
implements BasicContainer {
    private static final String NBT_ITEM = "Item";
    private final DiskDrivePeripheral peripheral = new DiskDrivePeripheral(this);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    @GuardedBy(value="this")
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    @GuardedBy(value="this")
    private MediaStack media = MediaStack.EMPTY;
    @Nullable
    @GuardedBy(value="this")
    private Mount mount;
    private boolean recordPlaying = false;
    private final AtomicReference<RecordCommand> recordQueued = new AtomicReference<Object>(null);
    private final AtomicBoolean ejectQueued = new AtomicBoolean(false);
    private final AtomicBoolean stackDirty = new AtomicBoolean(false);

    public DiskDriveBlockEntity(BlockEntityType<DiskDriveBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.updateMedia();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)DiskDriveBlock.FACING);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.setDiskStack(nbt.contains(NBT_ITEM) ? ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(NBT_ITEM)) : ItemStack.EMPTY);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ItemStack stack = this.getDiskStack();
        if (!stack.isEmpty()) {
            tag.put(NBT_ITEM, stack.save(registries));
        }
    }

    void serverTick() {
        RecordCommand recordQueued;
        if (this.stackDirty.getAndSet(false)) {
            this.updateDiskFromMedia();
        }
        if (this.ejectQueued.getAndSet(false)) {
            this.ejectContents();
        }
        if ((recordQueued = (RecordCommand)this.recordQueued.getAndSet(null)) != null) {
            switch (recordQueued.ordinal()) {
                case 0: {
                    MediaStack media = this.getMedia();
                    Holder<JukeboxSong> record = media.getAudio((HolderLookup.Provider)this.getLevel().registryAccess());
                    if (record == null) break;
                    this.recordPlaying = true;
                    this.sendMessage(new PlayRecordClientMessage(this.getBlockPos(), Optional.of(record)));
                    break;
                }
                case 1: {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public void setItems(NonNullList<ItemStack> items) {
        BasicContainer.defaultSetItems(this.inventory, items);
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide) {
            this.updateMedia();
        }
        super.setChanged();
    }

    private synchronized void updateMedia() {
        ItemStack newStack = this.getDiskStack();
        if (ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)this.media.stack())) {
            return;
        }
        MediaStack newMedia = MediaStack.of(newStack);
        if (newStack.isEmpty()) {
            this.updateBlockState(DiskDriveState.EMPTY);
        } else {
            this.updateBlockState(newMedia.media() != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        }
        if (!this.media.stack().isEmpty()) {
            for (Map.Entry<IComputerAccess, MountInfo> computer : this.computers.entrySet()) {
                DiskDriveBlockEntity.unmountDisk(computer.getKey(), computer.getValue());
            }
        }
        if (this.recordPlaying) {
            this.stopRecord();
            this.recordPlaying = false;
        }
        this.mount = null;
        this.media = newMedia;
        this.stackDirty.set(false);
        if (!newStack.isEmpty() && !this.computers.isEmpty()) {
            Mount mount = this.getOrCreateMount(true);
            for (Map.Entry<IComputerAccess, MountInfo> entry : this.computers.entrySet()) {
                DiskDriveBlockEntity.mountDisk(entry.getKey(), entry.getValue(), mount);
            }
        }
    }

    ItemStack getDiskStack() {
        return this.getItem(0);
    }

    synchronized MediaStack getMedia() {
        return this.media;
    }

    void setDiskStack(ItemStack stack) {
        this.setItem(0, stack);
        this.setChanged();
    }

    private synchronized void updateDiskFromMedia() {
        this.setItem(0, this.media.stack().copy());
        super.setChanged();
    }

    @GuardedBy(value="this")
    private void updateMediaStack(ItemStack stack, boolean immediate) {
        if (ItemStack.isSameItemSameComponents((ItemStack)this.media.stack(), (ItemStack)stack)) {
            return;
        }
        this.media = new MediaStack(stack, this.media.media());
        if (immediate) {
            this.updateDiskFromMedia();
        } else {
            this.stackDirty.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getDiskMountPath(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = new MountInfo();
            this.computers.put(computer, info);
            if (!this.media.stack().isEmpty()) {
                ServerLevel l;
                Level level = this.level;
                DiskDriveBlockEntity.mountDisk(computer, info, this.getOrCreateMount(level instanceof ServerLevel && (l = (ServerLevel)level).getServer().isSameThread()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            DiskDriveBlockEntity.unmountDisk(computer, this.computers.remove(computer));
        }
    }

    void playDiskAudio() {
        this.recordQueued.set(RecordCommand.PLAY);
    }

    void stopDiskAudio() {
        this.recordQueued.set(RecordCommand.STOP);
    }

    void ejectDisk() {
        this.ejectQueued.set(true);
    }

    synchronized MountResult setDiskLabel(@Nullable String label) {
        if (this.media.media() == null) {
            return MountResult.NO_MEDIA;
        }
        ItemStack stack = this.media.stack().copy();
        if (!this.media.media().setLabel(stack, label)) {
            return MountResult.NOT_ALLOWED;
        }
        this.updateMediaStack(stack, true);
        return MountResult.CHANGED;
    }

    @Nullable
    @GuardedBy(value="this")
    private Mount getOrCreateMount(boolean immediate) {
        if (this.media.media() == null) {
            return null;
        }
        if (this.mount != null) {
            return this.mount;
        }
        ItemStack stack = this.media.stack().copy();
        this.mount = this.media.media().createDataMount(stack, (ServerLevel)this.getLevel());
        this.updateMediaStack(stack, immediate);
        return this.mount;
    }

    private static void mountDisk(IComputerAccess computer, MountInfo info, @Nullable Mount mount) {
        if (mount instanceof WritableMount) {
            WritableMount writable = (WritableMount)mount;
            int n = 1;
            while (info.mountPath == null) {
                info.mountPath = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), writable);
                ++n;
            }
        } else if (mount != null) {
            int n = 1;
            while (info.mountPath == null) {
                info.mountPath = computer.mount((String)(n == 1 ? "disk" : "disk" + n), mount);
                ++n;
            }
        } else assert (info.mountPath == null) : "Mount path should be null";
        computer.queueEvent("disk", computer.getAttachmentName());
    }

    private static void unmountDisk(IComputerAccess computer, MountInfo info) {
        if (info.mountPath != null) {
            computer.unmount(info.mountPath);
            info.mountPath = null;
        }
        computer.queueEvent("disk_eject", computer.getAttachmentName());
    }

    private void updateBlockState(DiskDriveState state) {
        BlockState blockState = this.getBlockState();
        if (blockState.getValue(DiskDriveBlock.STATE) == state) {
            return;
        }
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue(DiskDriveBlock.STATE, (Comparable)((Object)state)));
    }

    private void ejectContents() {
        if (this.getLevel().isClientSide) {
            return;
        }
        ItemStack stack = this.getDiskStack();
        if (stack.isEmpty()) {
            return;
        }
        this.setDiskStack(ItemStack.EMPTY);
        WorldUtil.dropItemStack(this.getLevel(), this.getBlockPos(), this.getDirection(), stack);
        this.getLevel().levelEvent(1000, this.getBlockPos(), 0);
    }

    private void stopRecord() {
        this.sendMessage(new PlayRecordClientMessage(this.getBlockPos()));
    }

    private void sendMessage(PlayRecordClientMessage message) {
        ServerNetworking.sendToAllAround(message, (ServerLevel)this.getLevel(), Vec3.atCenterOf((Vec3i)this.getBlockPos()), 64.0f);
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new DiskDriveMenu(id, inventory, this);
    }

    private static enum RecordCommand {
        PLAY,
        STOP;

    }

    private static final class MountInfo {
        @Nullable
        String mountPath;

        private MountInfo() {
        }
    }

    static enum MountResult {
        NO_MEDIA,
        NOT_ALLOWED,
        CHANGED;

    }
}

