/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public final class NetworkMessages {
    private static final Set<String> seenChannel = new HashSet<String>();
    private static final List<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ServerNetworkContext>>> serverMessages = new ArrayList<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ServerNetworkContext>>>();
    private static final List<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ClientNetworkContext>>> clientMessages = new ArrayList<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ClientNetworkContext>>>();
    public static final CustomPacketPayload.Type<ComputerActionServerMessage> COMPUTER_ACTION = NetworkMessages.registerServerbound("computer_action", ComputerActionServerMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<QueueEventServerMessage> QUEUE_EVENT = NetworkMessages.register(serverMessages, "queue_event", QueueEventServerMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<KeyEventServerMessage> KEY_EVENT = NetworkMessages.registerServerbound("key_event", KeyEventServerMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<MouseEventServerMessage> MOUSE_EVENT = NetworkMessages.registerServerbound("mouse_event", MouseEventServerMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<UploadFileMessage> UPLOAD_FILE = NetworkMessages.register(serverMessages, "upload_file", UploadFileMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<ChatTableClientMessage> CHAT_TABLE = NetworkMessages.registerClientbound("chat_table", ChatTableClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<PocketComputerDataMessage> POCKET_COMPUTER_DATA = NetworkMessages.registerClientbound("pocket_computer_data", PocketComputerDataMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<PocketComputerDeletedClientMessage> POCKET_COMPUTER_DELETED = NetworkMessages.registerClientbound("pocket_computer_deleted", PocketComputerDeletedClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<ComputerTerminalClientMessage> COMPUTER_TERMINAL = NetworkMessages.registerClientbound("computer_terminal", ComputerTerminalClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<PlayRecordClientMessage> PLAY_RECORD = NetworkMessages.registerClientbound("play_record", PlayRecordClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<MonitorClientMessage> MONITOR_CLIENT = NetworkMessages.registerClientbound("monitor_client", MonitorClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<SpeakerAudioClientMessage> SPEAKER_AUDIO = NetworkMessages.registerClientbound("speaker_audio", SpeakerAudioClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<SpeakerMoveClientMessage> SPEAKER_MOVE = NetworkMessages.registerClientbound("speaker_move", SpeakerMoveClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<SpeakerPlayClientMessage> SPEAKER_PLAY = NetworkMessages.registerClientbound("speaker_play", SpeakerPlayClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<SpeakerStopClientMessage> SPEAKER_STOP = NetworkMessages.registerClientbound("speaker_stop", SpeakerStopClientMessage.STREAM_CODEC);
    public static final CustomPacketPayload.Type<UploadResultMessage> UPLOAD_RESULT = NetworkMessages.registerClientbound("upload_result", UploadResultMessage.STREAM_CODEC);

    private NetworkMessages() {
    }

    private static <C, T extends NetworkMessage<C>> CustomPacketPayload.Type<T> register(List<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<C>>> messages, String channel, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        if (!seenChannel.add(channel)) {
            throw new IllegalArgumentException("Duplicate channel " + channel);
        }
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)channel));
        messages.add(new CustomPacketPayload.TypeAndCodec(type, codec));
        return type;
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> CustomPacketPayload.Type<T> registerServerbound(String id, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return NetworkMessages.register(serverMessages, id, codec);
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> CustomPacketPayload.Type<T> registerClientbound(String id, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return NetworkMessages.register(clientMessages, id, codec);
    }

    public static Collection<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ServerNetworkContext>>> getServerbound() {
        return Collections.unmodifiableCollection(serverMessages);
    }

    public static Collection<CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ClientNetworkContext>>> getClientbound() {
        return Collections.unmodifiableCollection(clientMessages);
    }
}

