/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class RecipeModHelpers {
    static final List<Supplier<TurtleItem>> TURTLES = List.of(ModRegistry.Items.TURTLE_NORMAL, ModRegistry.Items.TURTLE_ADVANCED);
    static final List<Supplier<PocketComputerItem>> POCKET_COMPUTERS = List.of(ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);

    private RecipeModHelpers() {
    }

    public static boolean shouldRemoveRecipe(ResourceLocation id) {
        if (!id.getNamespace().equals("computercraft")) {
            return false;
        }
        String path = id.getPath();
        return path.startsWith("turtle_normal/") || path.startsWith("turtle_advanced/") || path.startsWith("pocket_normal/") || path.startsWith("pocket_advanced/");
    }

    public static List<ItemStack> getExtraStacks(HolderLookup.Provider registries) {
        ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
        for (Supplier<TurtleItem> supplier : TURTLES) {
            TurtleItem turtle = supplier.get();
            RecipeModHelpers.forEachRegistry(registries, ITurtleUpgrade.REGISTRY, upgrade -> upgradeItems.add(DataComponentUtil.createStack((ItemLike)turtle, (DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(upgrade))));
        }
        for (Supplier<IMedia> supplier : POCKET_COMPUTERS) {
            PocketComputerItem pocket = (PocketComputerItem)supplier.get();
            RecipeModHelpers.forEachRegistry(registries, IPocketUpgrade.REGISTRY, upgrade -> upgradeItems.add(DataComponentUtil.createStack((ItemLike)pocket, (DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(upgrade))));
        }
        return upgradeItems;
    }

    static <T> void forEachRegistry(HolderLookup.Provider registries, ResourceKey<Registry<T>> registry, Consumer<Holder.Reference<T>> consumer) {
        registries.lookup(registry).map(HolderLookup::listElements).orElse(Stream.empty()).forEach(consumer);
    }
}

