/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.shared.command.arguments.ArgumentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;

public final class RepeatArgumentType<T, U>
implements ArgumentType<List<T>> {
    private final ArgumentType<U> child;
    private final BiConsumer<List<T>, U> appender;
    private final boolean flatten;
    private final SimpleCommandExceptionType some;

    private RepeatArgumentType(ArgumentType<U> child, BiConsumer<List<T>, U> appender, boolean flatten, SimpleCommandExceptionType some) {
        this.child = child;
        this.appender = appender;
        this.flatten = flatten;
        this.some = some;
    }

    public static <T> RepeatArgumentType<T, T> some(ArgumentType<T> appender, SimpleCommandExceptionType missing) {
        return new RepeatArgumentType<T, Object>(appender, List::add, false, missing);
    }

    public static <T> RepeatArgumentType<T, List<T>> someFlat(ArgumentType<List<T>> appender, SimpleCommandExceptionType missing) {
        return new RepeatArgumentType<T, List>(appender, List::addAll, true, missing);
    }

    public List<T> parse(StringReader reader) throws CommandSyntaxException {
        ArrayList out;
        boolean hadSome;
        block2: {
            int startParse;
            hadSome = false;
            out = new ArrayList();
            do {
                reader.skipWhitespace();
                if (!reader.canRead()) break block2;
                startParse = reader.getCursor();
                this.appender.accept(out, this.child.parse(reader));
                hadSome = true;
            } while (reader.getCursor() != startParse);
            throw new IllegalStateException(String.valueOf(this.child) + " did not consume any input on " + reader.getRemaining());
        }
        if (!hadSome) {
            throw this.some.createWithContext((ImmutableStringReader)reader);
        }
        return Collections.unmodifiableList(out);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        int previous = reader.getCursor();
        while (reader.canRead()) {
            try {
                this.child.parse(reader);
            }
            catch (CommandSyntaxException e) {
                break;
            }
            int cursor = reader.getCursor();
            reader.skipWhitespace();
            if (cursor == reader.getCursor()) break;
            previous = reader.getCursor();
        }
        reader.setCursor(previous);
        return this.child.listSuggestions(context, builder.createOffset(previous));
    }

    public Collection<String> getExamples() {
        return this.child.getExamples();
    }

    public record Template(Info info, ArgumentTypeInfo.Template<?> child, boolean flatten, SimpleCommandExceptionType some) implements ArgumentTypeInfo.Template<RepeatArgumentType<?, ?>>
    {
        public RepeatArgumentType<?, ?> instantiate(CommandBuildContext commandBuildContext) {
            ArgumentType child = this.child().instantiate(commandBuildContext);
            return this.flatten ? RepeatArgumentType.someFlat(child, this.some()) : RepeatArgumentType.some(child, this.some());
        }

        public ArgumentTypeInfo<RepeatArgumentType<?, ?>, ?> type() {
            return this.info;
        }
    }

    public static class Info
    implements ArgumentTypeInfo<RepeatArgumentType<?, ?>, Template> {
        public void serializeToNetwork(Template arg, FriendlyByteBuf buf) {
            buf.writeBoolean(arg.flatten);
            ArgumentUtils.serializeToNetwork(buf, arg.child);
            ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC.encode((Object)buf, (Object)ArgumentUtils.getMessage(arg.some));
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buf) {
            boolean isList = buf.readBoolean();
            ArgumentTypeInfo.Template<?> child = ArgumentUtils.deserialize(buf);
            Component message = (Component)ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC.decode((Object)buf);
            return new Template(this, child, isList, new SimpleCommandExceptionType((Message)message));
        }

        public Template unpack(RepeatArgumentType<?, ?> argumentType) {
            return new Template(this, ArgumentTypeInfos.unpack(argumentType.child), argumentType.flatten, argumentType.some);
        }

        public void serializeToJson(Template arg, JsonObject json) {
            json.addProperty("flatten", Boolean.valueOf(arg.flatten));
            json.add("child", (JsonElement)ArgumentUtils.serializeToJson(arg.child));
            json.addProperty("error", Component.Serializer.toJson((Component)ArgumentUtils.getMessage(arg.some), (HolderLookup.Provider)RegistryAccess.EMPTY));
        }
    }
}

