/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

class BlockModelProvider {
    private static final TextureSlot CURSOR = TextureSlot.create((String)"cursor");
    private static final TextureSlot LEFT = TextureSlot.create((String)"left");
    private static final TextureSlot RIGHT = TextureSlot.create((String)"right");
    private static final TextureSlot BACKPACK = TextureSlot.create((String)"backpack");
    private static final ModelTemplate COMPUTER_ON = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/computer_on")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP, CURSOR});
    private static final ModelTemplate MONITOR_BASE = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/monitor_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.BACK});
    private static final ModelTemplate MODEM = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/modem")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.BACK});
    private static final ModelTemplate TURTLE = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.BACK, TextureSlot.TOP, TextureSlot.BOTTOM, LEFT, RIGHT, BACKPACK});
    private static final ModelTemplate TURTLE_UPGRADE_LEFT = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_upgrade_base_left")), Optional.of("_left"), new TextureSlot[]{TextureSlot.TEXTURE});
    private static final ModelTemplate TURTLE_UPGRADE_RIGHT = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_upgrade_base_right")), Optional.of("_left"), new TextureSlot[]{TextureSlot.TEXTURE});
    private static final BooleanProperty[] CABLE_DIRECTIONS = new BooleanProperty[]{CableBlock.DOWN, CableBlock.UP, CableBlock.NORTH, CableBlock.SOUTH, CableBlock.WEST, CableBlock.EAST};
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    BlockModelProvider() {
    }

    public static void addBlockModels(BlockModelGenerators generators) {
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_NORMAL.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_ADVANCED.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_COMMAND.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_NORMAL.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_ADVANCED.get());
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get()));
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get()));
        BlockModelProvider.registerWiredModems(generators);
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_NORMAL.get()));
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_ADVANCED.get()));
        generators.createHorizontallyRotatedBlock((Block)ModRegistry.Blocks.SPEAKER.get(), TexturedModel.ORIENTABLE_ONLY_TOP);
        BlockModelProvider.registerDiskDrive(generators);
        BlockModelProvider.registerPrinter(generators);
        BlockModelProvider.registerCable(generators);
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_crafting_table", "block/turtle_crafty_face");
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_speaker", "block/turtle_speaker_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_normal", "block/wireless_modem_normal_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_advanced", "block/wireless_modem_advanced_face");
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)ModRegistry.Blocks.LECTERN.get()), (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)Blocks.LECTERN))).with(BlockModelProvider.createHorizontalFacingDispatch()));
    }

    private static void registerDiskDrive(BlockModelGenerators generators) {
        DiskDriveBlock diskDrive = (DiskDriveBlock)((Object)ModRegistry.Blocks.DISK_DRIVE.get());
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)diskDrive).with(BlockModelProvider.createHorizontalFacingDispatch()).with(BlockModelProvider.createModelDispatch(DiskDriveBlock.STATE, value -> {
            String textureSuffix = switch (value) {
                default -> throw new MatchException(null, null);
                case DiskDriveState.EMPTY -> "_front";
                case DiskDriveState.INVALID -> "_front_rejected";
                case DiskDriveState.FULL -> "_front_accepted";
            };
            return ModelTemplates.CUBE_ORIENTABLE.createWithSuffix((Block)diskDrive, "_" + value.getSerializedName(), TextureMapping.orientableCube((Block)diskDrive).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)diskDrive, (String)textureSuffix)), generators.modelOutput);
        })));
        generators.delegateItemModel((Block)diskDrive, ModelLocationUtils.getModelLocation((Block)diskDrive, (String)"_empty"));
    }

    private static void registerPrinter(BlockModelGenerators generators) {
        PrinterBlock printer = (PrinterBlock)((Object)ModRegistry.Blocks.PRINTER.get());
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)printer).with(BlockModelProvider.createHorizontalFacingDispatch()).with(BlockModelProvider.createModelDispatch(PrinterBlock.TOP, PrinterBlock.BOTTOM, (top, bottom) -> {
            String texture;
            String model;
            if (top.booleanValue() && bottom.booleanValue()) {
                model = "_both_full";
                texture = "_both_trays";
            } else if (top.booleanValue()) {
                model = "_top_full";
                texture = "_top_tray";
            } else if (bottom.booleanValue()) {
                model = "_bottom_full";
                texture = "_bottom_tray";
            } else {
                model = "_empty";
                texture = "_empty";
            }
            return ModelTemplates.CUBE_ORIENTABLE.createWithSuffix((Block)printer, model, TextureMapping.orientableCube((Block)printer).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)printer, (String)("_front" + texture))), generators.modelOutput);
        })));
        generators.delegateItemModel((Block)printer, ModelLocationUtils.getModelLocation((Block)printer, (String)"_empty"));
    }

    private static void registerComputer(BlockModelGenerators generators, ComputerBlock<?> block) {
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant(block).with(BlockModelProvider.createHorizontalFacingDispatch()).with(BlockModelProvider.createModelDispatch(ComputerBlock.STATE, state -> switch (state) {
            default -> throw new MatchException(null, null);
            case ComputerState.OFF -> ModelTemplates.CUBE_ORIENTABLE.createWithSuffix((Block)block, "_" + state.getSerializedName(), TextureMapping.orientableCube((Block)block), generators.modelOutput);
            case ComputerState.ON, ComputerState.BLINKING -> COMPUTER_ON.createWithSuffix((Block)block, "_" + state.getSerializedName(), TextureMapping.orientableCube((Block)block).put(CURSOR, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/computer" + state.getTexture()))), generators.modelOutput);
        })));
        generators.delegateItemModel(block, ModelLocationUtils.getModelLocation(block, (String)"_blinking"));
    }

    private static void registerTurtle(BlockModelGenerators generators, TurtleBlock block) {
        ResourceLocation model = TURTLE.create((Block)block, new TextureMapping().put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)block, (String)"_front")).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)block, (String)"_back")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)block, (String)"_bottom")).put(LEFT, TextureMapping.getBlockTexture((Block)block, (String)"_left")).put(RIGHT, TextureMapping.getBlockTexture((Block)block, (String)"_right")).put(BACKPACK, TextureMapping.getBlockTexture((Block)block, (String)"_backpack")), generators.modelOutput);
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model)).with(BlockModelProvider.createHorizontalFacingDispatch()));
        generators.modelOutput.accept(ModelLocationUtils.getModelLocation((Item)block.asItem()), () -> {
            JsonObject out = new JsonObject();
            out.addProperty("loader", "computercraft:turtle");
            out.addProperty("model", model.toString());
            return out;
        });
    }

    private static void registerWirelessModem(BlockModelGenerators generators, WirelessModemBlock block) {
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(BlockModelProvider.createFacingDispatch()).with(BlockModelProvider.createModelDispatch(WirelessModemBlock.ON, on -> BlockModelProvider.modemModel(generators, ModelLocationUtils.getModelLocation((Block)block, (String)(on != false ? "_on" : "_off")), TextureMapping.getBlockTexture((Block)block, (String)("_face" + (on != false ? "_on" : "")))))));
        generators.delegateItemModel((Block)block, ModelLocationUtils.getModelLocation((Block)block, (String)"_off"));
    }

    private static void registerWiredModems(BlockModelGenerators generators) {
        WiredModemFullBlock fullBlock = (WiredModemFullBlock)((Object)ModRegistry.Blocks.WIRED_MODEM_FULL.get());
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)fullBlock).with(BlockModelProvider.createModelDispatch(WiredModemFullBlock.MODEM_ON, WiredModemFullBlock.PERIPHERAL_ON, (on, peripheral) -> {
            String suffix = (on != false ? "_on" : "_off") + (peripheral != false ? "_peripheral" : "");
            ResourceLocation faceTexture = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/wired_modem_face" + (peripheral != false ? "_peripheral" : "") + (on != false ? "_on" : "")));
            BlockModelProvider.modemModel(generators, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/wired_modem" + suffix)), faceTexture);
            return ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)fullBlock, (String)suffix), new TextureMapping().put(TextureSlot.ALL, faceTexture), generators.modelOutput);
        })));
        generators.delegateItemModel((Block)fullBlock, ModelLocationUtils.getModelLocation((Block)fullBlock, (String)"_off"));
        generators.delegateItemModel((Item)ModRegistry.Items.WIRED_MODEM.get(), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/wired_modem_off"));
    }

    private static ResourceLocation modemModel(BlockModelGenerators generators, ResourceLocation name, ResourceLocation texture) {
        return MODEM.create(name, new TextureMapping().put(TextureSlot.FRONT, texture).put(TextureSlot.BACK, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/modem_back")), generators.modelOutput);
    }

    private static void registerMonitor(BlockModelGenerators generators, MonitorBlock block) {
        BlockModelProvider.monitorModel(generators, block, "", 16, 4, 0, 32);
        BlockModelProvider.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        BlockModelProvider.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        BlockModelProvider.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        BlockModelProvider.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        BlockModelProvider.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        BlockModelProvider.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        BlockModelProvider.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        BlockModelProvider.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        BlockModelProvider.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        BlockModelProvider.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        BlockModelProvider.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        BlockModelProvider.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        BlockModelProvider.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        BlockModelProvider.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        BlockModelProvider.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        generators.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(BlockModelProvider.createHorizontalFacingDispatch()).with(BlockModelProvider.createVerticalFacingDispatch((Property<Direction>)MonitorBlock.ORIENTATION)).with(BlockModelProvider.createModelDispatch(MonitorBlock.STATE, edge -> ModelLocationUtils.getModelLocation((Block)block, (String)(edge == MonitorEdgeState.NONE ? "" : "_" + edge.getSerializedName())))));
        generators.delegateItemModel((Block)block, BlockModelProvider.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private static ResourceLocation monitorModel(BlockModelGenerators generators, MonitorBlock block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.create(ModelLocationUtils.getModelLocation((Block)block, (String)corners), new TextureMapping().put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)block, (String)("_" + front))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)("_" + side))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)("_" + top))).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)block, (String)("_" + back))), generators.modelOutput);
    }

    private static void registerCable(BlockModelGenerators generators) {
        MultiPartGenerator generator = MultiPartGenerator.multiPart((Block)((Block)ModRegistry.Blocks.CABLE.get()));
        ResourceLocation coreFacing = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/cable_core_facing");
        generator.with(Condition.or((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).term((Property)CableBlock.UP, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).term((Property)CableBlock.DOWN, (Comparable)Boolean.valueOf(true))}), Variant.variant().with(VariantProperties.MODEL, (Object)coreFacing).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90));
        generator.with(Condition.or((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).term((Property)CableBlock.NORTH, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).term((Property)CableBlock.SOUTH, (Comparable)Boolean.valueOf(true))}), Variant.variant().with(VariantProperties.MODEL, (Object)coreFacing).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0));
        generator.with(Condition.or((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).term((Property)CableBlock.EAST, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).term((Property)CableBlock.WEST, (Comparable)Boolean.valueOf(true))}), Variant.variant().with(VariantProperties.MODEL, (Object)coreFacing).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
        ResourceLocation core = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/cable_core_any");
        ArrayList<Condition.TerminalCondition> rightAngles = new ArrayList<Condition.TerminalCondition>();
        for (int i = 0; i < DirectionUtil.FACINGS.length; ++i) {
            for (int j = i; j < DirectionUtil.FACINGS.length; ++j) {
                if (DirectionUtil.FACINGS[i].getAxis() == DirectionUtil.FACINGS[j].getAxis()) continue;
                rightAngles.add(new Condition.TerminalCondition().term((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)).term((Property)CABLE_DIRECTIONS[i], (Comparable)Boolean.valueOf(true)).term((Property)CABLE_DIRECTIONS[j], (Comparable)Boolean.valueOf(true)));
            }
        }
        generator.with(Condition.or((Condition[])rightAngles.toArray(new Condition[0])), Variant.variant().with(VariantProperties.MODEL, (Object)core));
        ResourceLocation arm = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/cable_arm");
        for (Direction direction : DirectionUtil.FACINGS) {
            generator.with((Condition)new Condition.TerminalCondition().term((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)arm).with(VariantProperties.X_ROT, (Object)BlockModelProvider.toXAngle(direction.getOpposite())).with(VariantProperties.Y_ROT, (Object)BlockModelProvider.toYAngle(direction.getOpposite())));
        }
        for (Direction direction : DirectionUtil.FACINGS) {
            for (boolean on : BOOLEANS) {
                for (boolean peripheral : BOOLEANS) {
                    String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                    generator.with((Condition)new Condition.TerminalCondition().term(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.from(direction, on, peripheral))), Variant.variant().with(VariantProperties.MODEL, (Object)ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/wired_modem" + suffix))).with(VariantProperties.X_ROT, (Object)BlockModelProvider.toXAngle(direction)).with(VariantProperties.Y_ROT, (Object)BlockModelProvider.toYAngle(direction)));
                }
            }
        }
        generators.blockStateOutput.accept(generator);
    }

    private static Condition.TerminalCondition cableNoNeighbour(Direction ... directions) {
        Condition.TerminalCondition condition = new Condition.TerminalCondition().term((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true));
        for (Direction direction : directions) {
            condition.term((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(false));
        }
        return condition;
    }

    private static void registerTurtleUpgrade(BlockModelGenerators generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.create(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)(name + "_left")), TextureMapping.defaultTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)texture)), generators.modelOutput);
        TURTLE_UPGRADE_RIGHT.create(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)(name + "_right")), TextureMapping.defaultTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)texture)), generators.modelOutput);
    }

    private static void registerTurtleModem(BlockModelGenerators generators, String name, String texture) {
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_off", texture);
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_on", texture + "_on");
    }

    private static VariantProperties.Rotation toXAngle(Direction direction) {
        return switch (direction) {
            default -> VariantProperties.Rotation.R0;
            case Direction.UP -> VariantProperties.Rotation.R270;
            case Direction.DOWN -> VariantProperties.Rotation.R90;
        };
    }

    private static VariantProperties.Rotation toYAngle(Direction direction) {
        return switch (direction) {
            default -> VariantProperties.Rotation.R0;
            case Direction.NORTH -> VariantProperties.Rotation.R0;
            case Direction.SOUTH -> VariantProperties.Rotation.R180;
            case Direction.EAST -> VariantProperties.Rotation.R90;
            case Direction.WEST -> VariantProperties.Rotation.R270;
        };
    }

    private static PropertyDispatch createHorizontalFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING);
        for (Direction direction : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
            dispatch.select((Comparable)direction, Variant.variant().with(VariantProperties.Y_ROT, (Object)BlockModelProvider.toYAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createVerticalFacingDispatch(Property<Direction> property) {
        PropertyDispatch.C1 dispatch = PropertyDispatch.property(property);
        for (Direction direction : property.getPossibleValues()) {
            dispatch.select((Comparable)direction, Variant.variant().with(VariantProperties.X_ROT, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.property((Property)BlockStateProperties.FACING);
        for (Direction direction : BlockStateProperties.FACING.getPossibleValues()) {
            dispatch.select((Comparable)direction, Variant.variant().with(VariantProperties.Y_ROT, (Object)BlockModelProvider.toYAngle(direction)).with(VariantProperties.X_ROT, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static <T extends Comparable<T>> PropertyDispatch createModelDispatch(Property<T> property, Function<T, ResourceLocation> makeModel) {
        PropertyDispatch.C1 variant = PropertyDispatch.property(property);
        for (Comparable value : property.getPossibleValues()) {
            variant.select(value, Variant.variant().with(VariantProperties.MODEL, (Object)makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> PropertyDispatch createModelDispatch(Property<T> propertyT, Property<U> propertyU, BiFunction<T, U, ResourceLocation> makeModel) {
        PropertyDispatch.C2 variant = PropertyDispatch.properties(propertyT, propertyU);
        for (Comparable valueT : propertyT.getPossibleValues()) {
            for (Comparable valueU : propertyU.getPossibleValues()) {
                variant.select(valueT, valueU, Variant.variant().with(VariantProperties.MODEL, (Object)makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}

