/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.ComputerContext;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ApiLifecycle;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerExecutor;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.terminal.Terminal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class Computer {
    private static final int START_DELAY = 50;
    private final int id;
    @Nullable
    private String label = null;
    private final GlobalEnvironment globalEnvironment;
    private final Terminal terminal;
    private final ComputerExecutor executor;
    private final MainThreadScheduler.Executor serverExecutor;
    private final AtomicLong lastTaskId = new AtomicLong();
    private final Environment internalEnvironment;
    private final AtomicInteger externalOutputChanges = new AtomicInteger();
    private boolean startRequested;
    private int ticksSinceStart = -1;

    public Computer(ComputerContext context, ComputerEnvironment environment, Terminal terminal, int id) {
        if (id < 0) {
            throw new IllegalStateException("Id has not been assigned");
        }
        this.id = id;
        this.globalEnvironment = context.globalEnvironment();
        this.terminal = terminal;
        this.internalEnvironment = new Environment(this, environment);
        this.executor = new ComputerExecutor(this, environment, context);
        this.serverExecutor = context.mainThreadScheduler().createExecutor(environment.getMetrics());
    }

    GlobalEnvironment getGlobalEnvironment() {
        return this.globalEnvironment;
    }

    FileSystem getFileSystem() {
        return this.executor.getFileSystem();
    }

    Terminal getTerminal() {
        return this.terminal;
    }

    public Environment getEnvironment() {
        return this.internalEnvironment;
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.internalEnvironment;
    }

    public boolean isOn() {
        return this.executor.isOn();
    }

    public void turnOn() {
        this.startRequested = true;
    }

    public void shutdown() {
        this.executor.queueStop(false, false);
    }

    public void reboot() {
        this.executor.queueStop(true, false);
    }

    public void unload() {
        this.executor.queueStop(false, true);
    }

    public void queueEvent(String event, @Nullable Object[] args) {
        this.executor.queueEvent(event, args);
    }

    public boolean queueMainThread(Runnable runnable) {
        return this.serverExecutor.enqueue(runnable);
    }

    public WorkMonitor getMainThreadMonitor() {
        return this.serverExecutor;
    }

    public int getID() {
        return this.id;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable String label) {
        this.label = label;
    }

    public void tick() {
        if (this.ticksSinceStart >= 0 && this.ticksSinceStart <= 50) {
            ++this.ticksSinceStart;
        }
        if (this.startRequested && (this.ticksSinceStart < 0 || this.ticksSinceStart > 50)) {
            this.startRequested = false;
            if (!this.executor.isOn()) {
                this.ticksSinceStart = 0;
                this.executor.queueStart();
            }
        }
        this.executor.tick();
        this.internalEnvironment.tick();
        this.externalOutputChanges.accumulateAndGet(this.internalEnvironment.updateOutput(), (x, y) -> x | y);
    }

    public int pollAndResetChanges() {
        return this.externalOutputChanges.getAndSet(0);
    }

    public boolean isBlinking() {
        if (!this.isOn() || !this.terminal.getCursorBlink()) {
            return false;
        }
        int cursorX = this.terminal.getCursorX();
        int cursorY = this.terminal.getCursorY();
        return cursorX >= 0 && cursorX < this.terminal.getWidth() && cursorY >= 0 && cursorY < this.terminal.getHeight();
    }

    public void addApi(ILuaAPI api) {
        this.executor.addApi(api);
    }

    public void addApi(ILuaAPI api, ApiLifecycle lifecycleHooks) {
        this.executor.addApi(api, lifecycleHooks);
    }

    long getUniqueTaskId() {
        return this.lastTaskId.incrementAndGet();
    }
}

