/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import com.google.common.base.Strings;
import dan200.computercraft.core.CoreConfig;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.options.ProxyType;
import dan200.computercraft.core.util.ThreadUtils;
import dan200.computercraft.core.vendor.io.netty.handler.codec.DecoderException;
import dan200.computercraft.core.vendor.io.netty.handler.codec.TooLongFrameException;
import dan200.computercraft.core.vendor.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import dan200.computercraft.core.vendor.io.netty.handler.proxy.HttpProxyHandler;
import dan200.computercraft.core.vendor.io.netty.handler.proxy.Socks4ProxyHandler;
import dan200.computercraft.core.vendor.io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);
    public static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(4, ThreadUtils.lowPriorityFactory("Network"));
    public static final EventLoopGroup LOOP_GROUP = new NioEventLoopGroup(4, ThreadUtils.lowPriorityFactory("Netty"));
    private static final AbstractTrafficShapingHandler SHAPING_HANDLER = new GlobalTrafficShapingHandler((ScheduledExecutorService)EXECUTOR, (long)CoreConfig.httpUploadBandwidth, (long)CoreConfig.httpDownloadBandwidth);
    private static final Object sslLock;
    @Nullable
    private static SslContext sslContext;
    private static boolean triedSslContext;

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SslContext makeSslContext() {
        if (triedSslContext) {
            return sslContext;
        }
        Object object = sslLock;
        synchronized (object) {
            if (triedSslContext) {
                return sslContext;
            }
            triedSslContext = true;
            try {
                sslContext = SslContextBuilder.forClient().build();
                return sslContext;
            }
            catch (SSLException e) {
                LOG.error("Cannot construct SSL context", (Throwable)e);
                sslContext = null;
                return null;
            }
        }
    }

    public static SslContext getSslContext() throws HTTPRequestException {
        SslContext ssl = NetworkUtils.makeSslContext();
        if (ssl == null) {
            throw new HTTPRequestException("Could not create a secure connection");
        }
        return ssl;
    }

    public static void reloadConfig() {
        SHAPING_HANDLER.configure((long)CoreConfig.httpUploadBandwidth, (long)CoreConfig.httpDownloadBandwidth);
    }

    public static void reset() {
        SHAPING_HANDLER.trafficCounter().resetCumulativeTime();
    }

    public static InetSocketAddress getAddress(URI uri, boolean ssl) throws HTTPRequestException {
        return NetworkUtils.getAddress(uri.getHost(), uri.getPort(), ssl);
    }

    public static InetSocketAddress getAddress(String host, int port, boolean ssl) throws HTTPRequestException {
        InetSocketAddress socketAddress;
        if (port < 0) {
            int n = port = ssl ? 443 : 80;
        }
        if ((socketAddress = new InetSocketAddress(host, port)).isUnresolved()) {
            throw new HTTPRequestException("Unknown host");
        }
        return socketAddress;
    }

    public static Options getOptions(String host, InetSocketAddress address) throws HTTPRequestException {
        Options options = AddressRule.apply(CoreConfig.httpRules, host, address);
        if (options.action() == Action.DENY) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return options;
    }

    @Nullable
    public static Consumer<SocketChannel> getProxyHandler(Options options, int timeout) throws HTTPRequestException {
        if (!options.useProxy()) {
            return null;
        }
        ProxyType type = CoreConfig.httpProxyType;
        String host = CoreConfig.httpProxyHost;
        int port = CoreConfig.httpProxyPort;
        String username = CoreConfig.httpProxyUsername;
        String password = CoreConfig.httpProxyPassword;
        if (Strings.isNullOrEmpty((String)host)) {
            throw new HTTPRequestException("Proxy host not configured");
        }
        InetSocketAddress proxyAddress = new InetSocketAddress(host, port);
        if (proxyAddress.isUnresolved()) {
            throw new HTTPRequestException("Unknown proxy host");
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ProxyType.HTTP -> ch -> ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyAddress, username, password)});
            case ProxyType.HTTPS -> {
                SslContext sslContext = NetworkUtils.getSslContext();
                yield ch -> {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{NetworkUtils.makeSslHandler(ch, sslContext, timeout, host, port)});
                    p.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyAddress, username, password)});
                };
            }
            case ProxyType.SOCKS4 -> ch -> ch.pipeline().addLast(new ChannelHandler[]{new Socks4ProxyHandler(proxyAddress, username)});
            case ProxyType.SOCKS5 -> ch -> ch.pipeline().addLast(new ChannelHandler[]{new Socks5ProxyHandler(proxyAddress, username, password)});
        };
    }

    private static SslHandler makeSslHandler(SocketChannel ch, SslContext sslContext, int timeout, String peerHost, int peerPort) {
        SslHandler handler = sslContext.newHandler(ch.alloc(), peerHost, peerPort);
        if (timeout > 0) {
            handler.setHandshakeTimeoutMillis((long)timeout);
        }
        return handler;
    }

    public static void initChannel(SocketChannel ch, URI uri, InetSocketAddress socketAddress, @Nullable SslContext sslContext, @Nullable Consumer<SocketChannel> proxy, int timeout) {
        if (timeout > 0) {
            ch.config().setConnectTimeoutMillis(timeout);
        }
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{SHAPING_HANDLER});
        if (proxy != null) {
            proxy.accept(ch);
        }
        if (sslContext != null) {
            p.addLast(new ChannelHandler[]{NetworkUtils.makeSslHandler(ch, sslContext, timeout, uri.getHost(), socketAddress.getPort())});
        }
    }

    public static byte[] toBytes(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    public static String toFriendlyError(Throwable cause) {
        if (cause instanceof WebSocketHandshakeException || cause instanceof HTTPRequestException) {
            String message = cause.getMessage();
            return message == null ? "Could not connect" : message;
        }
        if (cause instanceof TooLongFrameException) {
            return "Message is too large";
        }
        if (cause instanceof ReadTimeoutException || cause instanceof ConnectTimeoutException) {
            return "Timed out";
        }
        if (cause instanceof SSLHandshakeException || cause instanceof DecoderException && cause.getCause() instanceof SSLHandshakeException) {
            return "Could not create a secure connection";
        }
        return "Could not connect";
    }

    static {
        EXECUTOR.setKeepAliveTime(60L, TimeUnit.SECONDS);
        sslLock = new Object();
        triedSslContext = false;
    }
}

