/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ModelTransformer {
    private static final int[] INVERSE_ORDER = new int[]{3, 2, 1, 0};
    private static final int STRIDE = 8;
    private static final int POS_OFFSET = 0;
    protected final Matrix4f transformation;
    protected final boolean invert;
    @Nullable
    private TransformedQuads cache;

    public ModelTransformer(Transformation transformation) {
        this.transformation = transformation.getMatrix();
        this.invert = transformation.getMatrix().determinant() < 0.0f;
    }

    public List<BakedQuad> transform(List<BakedQuad> quads) {
        if (quads.isEmpty()) {
            return List.of();
        }
        TransformedQuads cache = this.cache;
        if (cache != null && quads.equals(cache.original())) {
            return cache.transformed();
        }
        ArrayList<BakedQuad> transformed = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            transformed.add(this.transformQuad(quad));
        }
        this.cache = new TransformedQuads(quads, transformed);
        return transformed;
    }

    private BakedQuad transformQuad(BakedQuad quad) {
        int[] inputData = quad.getVertices();
        int[] outputData = new int[inputData.length];
        for (int i = 0; i < 4; ++i) {
            int inStart = 8 * i;
            int outStart = ModelTransformer.getVertexOffset(i, this.invert);
            System.arraycopy(inputData, inStart, outputData, outStart, 8);
            int inPosStart = inStart + 0;
            int outPosStart = outStart + 0;
            float x = Float.intBitsToFloat(inputData[inPosStart]);
            float y = Float.intBitsToFloat(inputData[inPosStart + 1]);
            float z = Float.intBitsToFloat(inputData[inPosStart + 2]);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            this.transformation.transformProject(pos);
            outputData[outPosStart] = Float.floatToRawIntBits(pos.x());
            outputData[outPosStart + 1] = Float.floatToRawIntBits(pos.y());
            outputData[outPosStart + 2] = Float.floatToRawIntBits(pos.z());
        }
        Direction direction = Direction.rotate((Matrix4f)this.transformation, (Direction)quad.getDirection());
        return new BakedQuad(outputData, quad.getTintIndex(), direction, quad.getSprite(), quad.isShade());
    }

    public static int getVertexOffset(int vertex, boolean invert) {
        return (invert ? INVERSE_ORDER[vertex] : vertex) * 8;
    }

    private record TransformedQuads(List<BakedQuad> original, List<BakedQuad> transformed) {
    }
}

