/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.network;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.AbstractPlayMessage;
import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.AbstractUnsidedPlayMessage;
import com.mojang.logging.LogUtils;
import java.util.function.BiFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record PlayMessageType<T extends AbstractUnsidedPlayMessage>(CustomPacketPayload.Type<T> id, StreamCodec<RegistryFriendlyByteBuf, T> codec, boolean allowNullPlayer, @Nullable PayloadAction<T, Player> client, @Nullable PayloadAction<T, ServerPlayer> server) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends AbstractClientPlayMessage> PlayMessageType<T> forClient(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory) {
        return PlayMessageType.forClient(modId, messageName, messageFactory, false, false);
    }

    public static <T extends AbstractServerPlayMessage> PlayMessageType<T> forServer(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory) {
        return PlayMessageType.forServer(modId, messageName, messageFactory, false, false);
    }

    public static <T extends AbstractPlayMessage> PlayMessageType<T> forBothSides(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory) {
        return PlayMessageType.forBothSides(modId, messageName, messageFactory, false, false);
    }

    public static <T extends AbstractClientPlayMessage> PlayMessageType<T> forClient(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory, boolean playerNullable, boolean executeOnNetworkThread) {
        return PlayMessageType.codecise(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), messageFactory, playerNullable, PlayMessageType.threadRedirect(AbstractClientPlayMessage::onExecute, executeOnNetworkThread), null);
    }

    public static <T extends AbstractServerPlayMessage> PlayMessageType<T> forServer(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory, boolean playerNullable, boolean executeOnNetworkThread) {
        return PlayMessageType.codecise(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), messageFactory, playerNullable, null, PlayMessageType.threadRedirect(AbstractServerPlayMessage::onExecute, executeOnNetworkThread));
    }

    public static <T extends AbstractPlayMessage> PlayMessageType<T> forBothSides(String modId, String messageName, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory, boolean playerNullable, boolean executeOnNetworkThread) {
        return PlayMessageType.codecise(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), messageFactory, playerNullable, PlayMessageType.threadRedirect(AbstractPlayMessage::onClientExecute, executeOnNetworkThread), PlayMessageType.threadRedirect(AbstractPlayMessage::onServerExecute, executeOnNetworkThread));
    }

    public static <T extends AbstractClientPlayMessage> PlayMessageType<T> forClient(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return PlayMessageType.forClient(modId, messageName, codec, false, false);
    }

    public static <T extends AbstractServerPlayMessage> PlayMessageType<T> forServer(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return PlayMessageType.forServer(modId, messageName, codec, false, false);
    }

    public static <T extends AbstractPlayMessage> PlayMessageType<T> forBothSides(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return PlayMessageType.forBothSides(modId, messageName, codec, false, false);
    }

    public static <T extends AbstractClientPlayMessage> PlayMessageType<T> forClient(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec, boolean playerNullable, boolean executeOnNetworkThread) {
        return new PlayMessageType<AbstractClientPlayMessage>(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), codec, playerNullable, PlayMessageType.threadRedirect(AbstractClientPlayMessage::onExecute, executeOnNetworkThread), null);
    }

    public static <T extends AbstractServerPlayMessage> PlayMessageType<T> forServer(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec, boolean playerNullable, boolean executeOnNetworkThread) {
        return new PlayMessageType<AbstractServerPlayMessage>(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), codec, playerNullable, null, PlayMessageType.threadRedirect(AbstractServerPlayMessage::onExecute, executeOnNetworkThread));
    }

    public static <T extends AbstractPlayMessage> PlayMessageType<T> forBothSides(String modId, String messageName, StreamCodec<RegistryFriendlyByteBuf, T> codec, boolean playerNullable, boolean executeOnNetworkThread) {
        return new PlayMessageType<AbstractPlayMessage>(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)modId, (String)messageName)), codec, playerNullable, PlayMessageType.threadRedirect(AbstractPlayMessage::onClientExecute, executeOnNetworkThread), PlayMessageType.threadRedirect(AbstractPlayMessage::onServerExecute, executeOnNetworkThread));
    }

    public void register(PayloadRegistrar registry) {
        if (this.client != null && this.server != null) {
            registry.playBidirectional(this.id, this.codec, this::onBidirectional);
        } else if (this.client != null) {
            registry.playToClient(this.id, this.codec, this::onClient);
        } else if (this.server != null) {
            registry.playToServer(this.id, this.codec, this::onServer);
        }
    }

    private void onBidirectional(T payload, IPayloadContext context) {
        switch (context.flow()) {
            case CLIENTBOUND: {
                this.onClient(payload, context);
                break;
            }
            case SERVERBOUND: {
                this.onServer(payload, context);
            }
        }
    }

    private void onClient(T payload, IPayloadContext context) {
        Player player = context.player();
        if (!this.allowNullPlayer && player == null) {
            PlayMessageType.wrongPlayerException(context, payload);
            return;
        }
        this.client.handle(payload, context, player);
    }

    private void onServer(T payload, IPayloadContext context) {
        ServerPlayer sp;
        ServerPlayer serverPlayer;
        Player player = context.player();
        ServerPlayer serverPlayer2 = serverPlayer = player instanceof ServerPlayer ? (sp = (ServerPlayer)player) : null;
        if (!this.allowNullPlayer && serverPlayer == null) {
            PlayMessageType.wrongPlayerException(context, payload);
            return;
        }
        this.server.handle(payload, context, serverPlayer);
    }

    private static <T extends AbstractUnsidedPlayMessage, U extends Player> PayloadAction<T, U> threadRedirect(PayloadAction<T, U> payloadAction, boolean executeOnNetworkThread) {
        return executeOnNetworkThread ? payloadAction : (payload, context, player) -> context.enqueueWork(() -> payloadAction.handle(payload, context, player));
    }

    private static void wrongPlayerException(IPayloadContext context, AbstractUnsidedPlayMessage payload) {
        Player player = context.player();
        LOGGER.warn("Invalid packet received for - " + payload.getClass().getName() + " player: " + (player == null ? "MISSING" : player.getClass().getName()) + " logical-side: " + String.valueOf(context.flow().getReceptionSide()));
    }

    private static <T extends AbstractUnsidedPlayMessage> PlayMessageType<T> codecise(CustomPacketPayload.Type<T> id, BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory, boolean allowNullPlayer, @Nullable PayloadAction<T, Player> client, @Nullable PayloadAction<T, ServerPlayer> server) {
        MessageStreamCodec<T> codec = new MessageStreamCodec<T>(messageFactory);
        PlayMessageType<T> type = new PlayMessageType<T>(id, codec, allowNullPlayer, client, server);
        codec.type = type;
        return type;
    }

    @FunctionalInterface
    private static interface PayloadAction<T, U> {
        public void handle(T var1, IPayloadContext var2, U var3);
    }

    private static class MessageStreamCodec<T extends AbstractUnsidedPlayMessage>
    implements StreamCodec<RegistryFriendlyByteBuf, T> {
        private final BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory;
        private PlayMessageType<T> type;

        private MessageStreamCodec(BiFunction<RegistryFriendlyByteBuf, PlayMessageType<T>, T> messageFactory) {
            this.messageFactory = messageFactory;
        }

        public T decode(RegistryFriendlyByteBuf buf) {
            return (T)((AbstractUnsidedPlayMessage)this.messageFactory.apply(buf, this.type));
        }

        public void encode(RegistryFriendlyByteBuf buf, T msg) {
            ((AbstractUnsidedPlayMessage)msg).toBytes(buf);
        }
    }
}

