/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.language;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ldtteam.common.language.ClientLocale;
import com.ldtteam.common.language.ServerLocale;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.commons.io.IOUtils;

public final class LanguageHandler {
    private LanguageHandler() {
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public static String format(String key, Object ... args) {
        String result = (args.length == 0 ? Component.translatable((String)key) : Component.translatable((String)key, (Object[])args)).getString();
        return result.isEmpty() ? key : result;
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public static String translateKeyWithFormat(String key, Object ... format) {
        return String.format(LanguageHandler.translateKey(key), format);
    }

    public static String translateKey(String key) {
        return LanguageCache.getInstance().translateKey(key);
    }

    public static void setMClanguageLoaded() {
        LanguageCache.getInstance().isMCloaded = true;
        LanguageCache.getInstance().languageMap = null;
    }

    public static void loadLangPath(String path) {
        LanguageCache.getInstance().load(path);
    }

    private static class LanguageCache {
        private static final String defaultLocale = "en_us";
        private static final LanguageCache instance = new LanguageCache();
        private boolean isMCloaded = false;
        private Map<String, String> languageMap = new ConcurrentHashMap<String, String>();

        private LanguageCache() {
            this.load("assets/blockui/lang/%s.json");
        }

        private void load(String path) {
            String locale = FMLEnvironment.dist.isClient() ? ClientLocale.getLocale() : ServerLocale.getLocale();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, locale));
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(path, defaultLocale));
            }
            this.languageMap.putAll((Map)new Gson().fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(this){}.getType()));
            IOUtils.closeQuietly((InputStream)is);
        }

        private static LanguageCache getInstance() {
            return instance;
        }

        private String translateKey(String key) {
            if (this.isMCloaded) {
                return Language.getInstance().getOrDefault(key);
            }
            String res = this.languageMap.get(key);
            return res == null ? Language.getInstance().getOrDefault(key) : res;
        }
    }
}

