/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.ScrollingContainer;
import com.ldtteam.blockui.views.ScrollingListContainer;
import com.ldtteam.blockui.views.ScrollingView;
import java.util.List;
import java.util.function.IntSupplier;
import net.minecraft.network.chat.MutableComponent;

public class ScrollingList
extends ScrollingView {
    protected int childSpacing = 0;
    protected DataProvider dataProvider;
    private int maxHeight;

    public ScrollingList() {
    }

    public ScrollingList(PaneParams params) {
        super(params);
        this.childSpacing = params.getInteger("childspacing", this.childSpacing);
        this.setMaxHeight(this.height);
        this.setEmptyTextColor(params.getColor("emptycolor", 0xFFFFFF));
        this.setEmptyTextScale(params.getDouble("emptyscale", 1.0));
        this.setEmptyText(params.getMultilineText("emptytext"));
    }

    public void setEmptyText(MutableComponent emptyText) {
        this.setEmptyText(List.of(emptyText));
    }

    public void setEmptyText(List<MutableComponent> emptyText) {
        ((ScrollingListContainer)this.container).setEmptyText(emptyText);
    }

    public void setEmptyTextColor(int emptyTextColor) {
        ((ScrollingListContainer)this.container).setEmptyTextColor(emptyTextColor);
    }

    public void setEmptyTextScale(double emptyTextScale) {
        ((ScrollingListContainer)this.container).setEmptyTextScale(emptyTextScale);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setDataProvider(final IntSupplier countSupplier, final IPaneUpdater paneUpdater) {
        this.setDataProvider(new DataProvider(){

            @Override
            public int getElementCount() {
                return countSupplier.getAsInt();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                paneUpdater.apply(index, rowPane);
            }
        });
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.refreshElementPanes(true);
    }

    public void refreshElementPanes() {
        this.refreshElementPanes(true);
    }

    public void refreshElementPanes(boolean force) {
        ((ScrollingListContainer)this.container).refreshElementPanes(this.dataProvider, this.maxHeight, this.childSpacing, force);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.refreshElementPanes(false);
    }

    @Override
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingListContainer(this);
    }

    @Override
    public void parseChildren(PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes.isEmpty()) {
            return;
        }
        ScrollingContainer scrollingContainer = this.container;
        if (scrollingContainer instanceof ScrollingListContainer) {
            ScrollingListContainer scrollingListContainer = (ScrollingListContainer)scrollingContainer;
            scrollingListContainer.setListNodeParams(childNodes.get(0));
        }
    }

    public int getListElementIndexByPane(Pane pane) {
        return ((ScrollingListContainer)this.container).getListElementIndexByPane(pane);
    }

    @FunctionalInterface
    public static interface IPaneUpdater {
        public void apply(int var1, Pane var2);
    }

    public static interface DataProvider {
        public int getElementCount();

        default public boolean shouldUpdate() {
            return true;
        }

        default public boolean shouldUpdate(int index) {
            return true;
        }

        default public void modifyRowSize(int index, ScrollingListContainer.RowSizeModifier modifier) {
        }

        public void updateElement(int var1, Pane var2);
    }
}

