/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgykubejs;

import com.google.common.base.Suppliers;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.tooltips.TooltipHandler;
import com.klikli_dev.theurgykubejs.AlchemicalDerivativeItemType;
import com.klikli_dev.theurgykubejs.TheurgyKubeJS;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class AlchemicalSulfurItemType
extends AlchemicalDerivativeItemType {
    public transient AlchemicalSulfurType sulfurType;

    public AlchemicalSulfurItemType(ResourceLocation rl) {
        super(rl);
    }

    @Override
    protected Item.Properties decorateWithSource(Item.Properties properties) {
        if (this.sourceItem != null) {
            properties.component((Supplier)DataComponentRegistry.SOURCE_ITEM, (Object)((Holder)BuiltInRegistries.ITEM.getHolder(this.sourceItem).get()));
        } else if (this.sourceTag != null) {
            properties.component((Supplier)DataComponentRegistry.SOURCE_TAG, (Object)ItemTags.create((ResourceLocation)this.sourceTag));
        }
        return properties;
    }

    public Item createObject() {
        AlchemicalSulfurItem item = new AlchemicalSulfurItem(this.decorateWithSource(this.createItemProperties()));
        item.useCustomSourceName(true).autoTooltip(this.provideDerivativeInformationAsTooltipParam, false).autoName(this.provideDerivativeInformationAsNameParam, false).withJarIcon((Supplier)Suppliers.memoize(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.jarIcon)))).tier(this.derivativeTier);
        item.type(this.sulfurType);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            TooltipHandler.registerTooltipDataProvider((Item)item, arg_0 -> ((AlchemicalSulfurItem)item).getTooltipData(arg_0));
            TheurgyKubeJS.Client.registerAlchemicalDerivativeItem((Item)item);
        }
        return item;
    }

    @Info(value="Sets the Sulfur Type (MISC, GEMS, METALS, OTHER_MINERALS, LOGS, CROPS, ANIMALS, MOBS).")
    public ItemBuilder sulfurType(AlchemicalSulfurType type) {
        this.sulfurType = type;
        return this;
    }

    @Override
    public void generateLang(LangKubeEvent lang) {
        super.generateLang(lang);
        if (this.generateNameLangEntry) {
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey(), "Alchemical Sulfur %s");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".source", this.sourceName);
        }
        if (this.generateTooltipLangEntry) {
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip", "Alchemical Sulfur crafted from %s %s %s.");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip.extended", "Sulfur represents the \"idea\" or \"soul\" of an object");
            lang.add(this.id.getNamespace(), this.getBuilderTranslationKey() + ".tooltip.usage", "Sulfur is the central element used in Spagyrics processes.\n\n" + String.valueOf(ChatFormatting.ITALIC) + "Hint: Sulfurs crafted from different states of the same material (such as from Ore or Ingots) are interchangeable." + String.valueOf(ChatFormatting.RESET));
        }
    }
}

