/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei;

import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.integration.jei.JeiPlugin;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemMeltingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<ItemMeltingRecipe>> {
    private static List<FluidStack> fuels = new ArrayList<FluidStack>();
    private final IDrawable background;

    public ItemMeltingRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.ITEM_MELTING, (Component)Component.translatable((String)"jei.productivemetalworks.item_melting"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MetalworksRegistrator.FOUNDRY_CONTROLLERS.get(DyeColor.BLACK).get())), 165, 68);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/jei/item_melting.png"), 0, 0, 165, 68).setTextureSize(165, 68).build();
        if (fuels.isEmpty()) {
            fuels = BuiltInRegistries.FLUID.holders().filter(fluidReference -> fluidReference.getData(MetalworksRegistrator.FUEL_MAP) != null).map(fluidReference -> new FluidStack((Fluid)fluidReference.value(), 1000)).toList();
        }
    }

    public void draw(RecipeHolder<ItemMeltingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        guiGraphics.drawString(Minecraft.getInstance().font, Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"jei.productivemetalworks.temperature", (Object[])new Object[]{((ItemMeltingRecipe)recipe.value()).minTemperature})), 35, 52, -16777216, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ItemMeltingRecipe> recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 38, 26).addIngredients(((ItemMeltingRecipe)recipe.value()).item)).setStandardSlotBackground().setSlotName("ingredients");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 11, 8).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fuels.stream().filter(fluidStack -> {
            FuelMap fueldData = (FuelMap)fluidStack.getFluidHolder().getData(MetalworksRegistrator.FUEL_MAP);
            return fueldData != null && fueldData.temperature() >= ((ItemMeltingRecipe)recipe.value()).minTemperature;
        }).toList())).setFluidRenderer(1000L, false, 16, 52).setSlotName("fuel");
        int maxAmount = ((ItemMeltingRecipe)recipe.value()).result.stream().max(Comparator.comparingInt(FluidStack::getAmount)).get().getAmount();
        int fWidth = 42 / ((ItemMeltingRecipe)recipe.value()).result.size();
        for (int i = 0; i < ((ItemMeltingRecipe)recipe.value()).result.size(); ++i) {
            FluidStack fluid = ((ItemMeltingRecipe)recipe.value()).result.get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 112 + i * fWidth, 8).addFluidStack(fluid.getFluid(), (long)fluid.getAmount()).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip(fluid))).setFluidRenderer((long)maxAmount, false, fWidth, 52).setSlotName("fluid" + i);
        }
    }
}

