/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.event;

import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivemetalworks.ProductiveMetalworks;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.network.MoveFoundryFluidData;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@EventBusSubscriber(modid="productivemetalworks", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void registerBlockEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)MetalworksRegistrator.FOUNDRY_DRAIN_BLOCK_ENTITY.get(), (myBlockEntity, side) -> {
            Level patt0$temp = myBlockEntity.getLevel();
            if (patt0$temp instanceof Level) {
                BlockEntity patt1$temp;
                Level level = patt0$temp;
                if (myBlockEntity.getMultiblockController() != null && (patt1$temp = level.getBlockEntity(myBlockEntity.getMultiblockController())) instanceof FoundryControllerBlockEntity) {
                    FoundryControllerBlockEntity foundryController = (FoundryControllerBlockEntity)patt1$temp;
                    return foundryController.getFluidHandler();
                }
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)MetalworksRegistrator.FOUNDRY_TANK_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)MetalworksRegistrator.FOUNDRY_CAPACITOR_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)MetalworksRegistrator.CASTING_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)MetalworksRegistrator.CASTING_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.canAcceptCast() ? myBlockEntity.castInv : myBlockEntity.getItemHandler());
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(MetalworksRegistrator.TAB_KEY)) {
            for (DeferredHolder item : ProductiveMetalworks.ITEMS.getEntries()) {
                event.accept((ItemLike)item.value());
            }
            event.accept((ItemLike)LibItems.UPGRADE_TIME.get());
            event.accept((ItemLike)LibItems.UPGRADE_TIME_2.get());
            event.accept((ItemLike)LibItems.UPGRADE_STABILITY.get());
        }
    }

    @SubscribeEvent
    private static void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        event.register(MetalworksRegistrator.FUEL_MAP);
        event.register(MetalworksRegistrator.POWER_COIL_MAP);
        event.register(MetalworksRegistrator.ENTITY_MELTING_MAP);
        event.register(MetalworksRegistrator.UNIT_MAP);
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("productivemetalworks").versioned("1");
        registrar.playToServer(MoveFoundryFluidData.TYPE, MoveFoundryFluidData.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(MoveFoundryFluidData::clientHandle, MoveFoundryFluidData::serverHandle));
    }
}

